/* spek.c generated by valac 0.10.4, the Vala compiler
 * generated from spek.vala, do not modify */

/* spek.vala
 *
 * Copyright (C) 2010-2011  Alexander Kojevnikov <alexander@kojevnikov.com>
 *
 * Spek is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Spek is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Spek.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <spek-platform.h>
#include <config.h>
#include <gtk/gtk.h>
#include <spek-audio.h>


#define SPEK_TYPE_PREFERENCES (spek_preferences_get_type ())
#define SPEK_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_PREFERENCES, SpekPreferences))
#define SPEK_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_PREFERENCES, SpekPreferencesClass))
#define SPEK_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_PREFERENCES))
#define SPEK_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_PREFERENCES))
#define SPEK_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_PREFERENCES, SpekPreferencesClass))

typedef struct _SpekPreferences SpekPreferences;
typedef struct _SpekPreferencesClass SpekPreferencesClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SPEK_TYPE_WINDOW (spek_window_get_type ())
#define SPEK_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPEK_TYPE_WINDOW, SpekWindow))
#define SPEK_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPEK_TYPE_WINDOW, SpekWindowClass))
#define SPEK_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPEK_TYPE_WINDOW))
#define SPEK_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPEK_TYPE_WINDOW))
#define SPEK_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPEK_TYPE_WINDOW, SpekWindowClass))

typedef struct _SpekWindow SpekWindow;
typedef struct _SpekWindowClass SpekWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern gboolean spek_version;
gboolean spek_version = FALSE;
extern char** spek_files;
char** spek_files = NULL;

gint spek_main (char** args, int args_length1);
gpointer spek_preferences_ref (gpointer instance);
void spek_preferences_unref (gpointer instance);
GParamSpec* spek_param_spec_preferences (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void spek_value_set_preferences (GValue* value, gpointer v_object);
void spek_value_take_preferences (GValue* value, gpointer v_object);
gpointer spek_value_get_preferences (const GValue* value);
GType spek_preferences_get_type (void) G_GNUC_CONST;
SpekPreferences* spek_preferences_get_instance (void);
char* spek_preferences_get_language (SpekPreferences* self);
SpekWindow* spek_window_new (const char* file_name);
SpekWindow* spek_window_construct (GType object_type, const char* file_name);
GType spek_window_get_type (void) G_GNUC_CONST;
static gint _vala_array_length (gpointer array);

const GOptionEntry SPEK_options[3] = {{"version", 'V', 0, G_OPTION_ARG_NONE, &spek_version, N_ ("Display the version and exit"), NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &spek_files, NULL, NULL}, {NULL}};


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, (gssize) (-1));
	return result;
}


gint spek_main (char** args, int args_length1) {
	gint result = 0;
	char* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp3_ = FALSE;
	const char* _tmp4_;
	char* file_name;
	gboolean _tmp5_ = FALSE;
	SpekWindow* window;
	GError * _inner_error_ = NULL;
	spek_platform_fix_args (args, args_length1);
	if ((_tmp1_ = string_get_length (_tmp0_ = spek_preferences_get_language (spek_preferences_get_instance ())) > 0, _g_free0 (_tmp0_), _tmp1_)) {
		char* _tmp2_;
		g_setenv ("LANGUAGE", _tmp2_ = spek_preferences_get_language (spek_preferences_get_instance ()), TRUE);
		_g_free0 (_tmp2_);
	}
	bindtextdomain (GETTEXT_PACKAGE, spek_platform_locale_dir ());
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	{
		gtk_init_with_args (&args_length1, &args, _ ("[FILE]"), (GOptionEntry*) SPEK_options, GETTEXT_PACKAGE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_print ("%s", e->message);
			g_print ("\n");
			g_print (_ ("Run `%s --help` to see a full list of available command line options.\n"), args[0]);
			result = 1;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (spek_version) {
		g_print (_ ("%s version %s\n"), PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	if (spek_files != NULL) {
		_tmp3_ = _vala_array_length (spek_files) != 1;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		g_print ("%s", _ ("Specify a single file\n"));
		result = 1;
		return result;
	}
	spek_platform_init ();
	spek_audio_init ();
	_tmp4_ = NULL;
	if (spek_files == NULL) {
		_tmp4_ = NULL;
	} else {
		_tmp4_ = spek_files[0];
	}
	file_name = g_strdup (_tmp4_);
	if (file_name != NULL) {
		_tmp5_ = g_str_has_prefix (file_name, "file://");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		{
			char* _tmp6_;
			char* _tmp7_;
			_tmp6_ = g_filename_from_uri (file_name, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					goto __catch1_g_convert_error;
				}
				_g_free0 (file_name);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
			file_name = (_tmp7_ = _tmp6_, _g_free0 (file_name), _tmp7_);
		}
		goto __finally1;
		__catch1_g_convert_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				_g_error_free0 (e);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (file_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	window = g_object_ref_sink (spek_window_new (file_name));
	gtk_main ();
	gtk_object_destroy ((GtkObject*) window);
	result = 0;
	_g_object_unref0 (window);
	_g_free0 (file_name);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return spek_main (argv, argc);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




