/*
 * gst-videoconverter-filter.c - Source for GstVideoconverterFilter
 *
 * Copyright (C) 2010 Collabora Ltd.
 *  @author: Youness Alaoui <youness.alaoui@collabora.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * SECTION:gst-videoconverter-filter
 * @short_description: A video converter filter
 *
 * This filter will convert video data from one format to another.
 */


#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif


#include <gst/filters/gst-videoconverter-filter.h>
#include <gst/filters/gst-filter-helper.h>

GST_DEFINE_FILTER (GstVideoconverterFilter, videoconverter);

static void
gst_videoconverter_filter_init (GstVideoconverterFilter * self)
{
}

/**
 * gst_videoconverter_filter_new:
 *
 * Creates a new videoconverter filter or reuse an existing one.
 * This filter will take care of converting video from one format to another.
 * It will basically just add an ffmpegcolorspace element the pipeline.
 *
 * Returns: A new #GstVideoconverterFilter
 */
GstVideoconverterFilter *
gst_videoconverter_filter_new (void)
{
  static GstVideoconverterFilter *singleton = NULL;
  static GStaticMutex mutex = G_STATIC_MUTEX_INIT;

  g_static_mutex_lock (&mutex);
  if (!singleton) {
    singleton = g_object_new (GST_TYPE_VIDEOCONVERTER_FILTER, NULL);
    g_object_add_weak_pointer (G_OBJECT (singleton), (gpointer *) & singleton);
  } else {
    g_object_ref (singleton);
  }
  g_static_mutex_unlock (&mutex);

  return singleton;
}

static GstPad *
gst_videoconverter_filter_apply (GstFilter * filter, GstBin * bin, GstPad * pad)
{
  return gst_filter_apply_element_by_name_default (bin, pad, "ffmpegcolorspace",
      NULL, NULL);
}

static GstPad *
gst_videoconverter_filter_revert (GstFilter * filter,
    GstBin * bin, GstPad * pad)
{
  return gst_filter_revert_element_default (bin, pad, NULL);
}
