/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.Entity;
import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.db.LibraryDB;
import com.frostwire.alexandria.db.LibraryDatabase;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Library
extends Entity<LibraryDB> {
    private int _id;
    private String _name;
    private int _version;

    public Library(File file) {
        super(new LibraryDB(new LibraryDatabase(file)));
        ((LibraryDB)this.db).fill(this);
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public int getVersion() {
        return this._version;
    }

    public void setVersion(int n) {
        this._version = n;
    }

    public void close() {
        ((LibraryDB)this.db).getDatabase().close();
    }

    public List<Playlist> getPlaylists() {
        List<Playlist> list = ((LibraryDB)this.db).getPlaylists(this);
        Collections.sort(list, new Comparator<Playlist>(){

            @Override
            public int compare(Playlist playlist, Playlist playlist2) {
                return playlist.getName().compareTo(playlist2.getName());
            }
        });
        return list;
    }

    public Playlist getPlaylist(String string) {
        return ((LibraryDB)this.db).getPlaylist(this, string);
    }

    public List<InternetRadioStation> getInternetRadioStations() {
        return ((LibraryDB)this.db).getInternetRadioStations(this);
    }

    public Playlist newPlaylist(String string, String string2) {
        return new Playlist(this, -1, string, string2);
    }

    public InternetRadioStation newInternetRadioStation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl) {
        return new InternetRadioStation(this, -1, string, string2, string3, string4, string5, string6, string7, string8, bl);
    }

    public void dump() {
        ((LibraryDB)this.db).getDatabase().dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public Playlist getStarredPlaylist() {
        return ((LibraryDB)this.db).getStarredPlaylist(this);
    }

    public void updatePlaylistItemProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        ((LibraryDB)this.db).updatePlaylistItemProperties(string, string2, string3, string4, string5, string6, string7, string8);
    }

    public long getTotalRadioStations() {
        return ((LibraryDB)this.db).getTotalRadioStations(this);
    }

    public void restoreDefaultRadioStations() {
        ((LibraryDB)this.db).restoreDefaultRadioStations(this);
    }
}

