/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

public final class LibraryUtils {
    private LibraryUtils() {
    }

    public static String luceneEncode(String string) {
        int n = string.length();
        string = string.replace("AND", " ").replace("OR", " ").replace("NOT", " ");
        StringBuilder stringBuilder = new StringBuilder(2 * n);
        block20: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '+': {
                    stringBuilder.append("\\+");
                    continue block20;
                }
                case '-': {
                    stringBuilder.append("\\-");
                    continue block20;
                }
                case '&': {
                    stringBuilder.append("\\&");
                    continue block20;
                }
                case '|': {
                    stringBuilder.append("\\r");
                    continue block20;
                }
                case '!': {
                    stringBuilder.append("\\!");
                    continue block20;
                }
                case '(': {
                    stringBuilder.append("\\(");
                    continue block20;
                }
                case ')': {
                    stringBuilder.append("\\)");
                    continue block20;
                }
                case '{': {
                    stringBuilder.append("\\{");
                    continue block20;
                }
                case '}': {
                    stringBuilder.append("\\}");
                    continue block20;
                }
                case '[': {
                    stringBuilder.append("\\[");
                    continue block20;
                }
                case ']': {
                    stringBuilder.append("\\]");
                    continue block20;
                }
                case '^': {
                    stringBuilder.append("\\^");
                    continue block20;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block20;
                }
                case '~': {
                    stringBuilder.append("\\~");
                    continue block20;
                }
                case '*': {
                    stringBuilder.append("\\*");
                    continue block20;
                }
                case '?': {
                    stringBuilder.append("\\?");
                    continue block20;
                }
                case ':': {
                    stringBuilder.append("\\:");
                    continue block20;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block20;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString().replaceAll("\\s+", " ");
    }

    public static String fuzzyLuceneQuery(String string) {
        String string2 = LibraryUtils.luceneEncode(string);
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 0) {
            return string2;
        }
        if (stringArray.length == 1) {
            return string2 + "~";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i] + "~ AND ");
        }
        stringBuilder.append(stringArray[stringArray.length - 1] + "~");
        return stringBuilder.toString().trim();
    }

    public static String wildcardLuceneQuery(String string) {
        String string2 = LibraryUtils.luceneEncode(string);
        String[] stringArray = string2.split(" ");
        if (stringArray.length == 0) {
            return string2;
        }
        if (stringArray.length == 1) {
            return string2 + "*";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i] + "* AND ");
        }
        stringBuilder.append(stringArray[stringArray.length - 1] + "*");
        return stringBuilder.toString().trim();
    }
}

