/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.Entity;
import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDB;
import com.frostwire.alexandria.db.PlaylistDB;
import java.util.LinkedList;
import java.util.List;

public class Playlist
extends Entity<PlaylistDB> {
    private final Library _library;
    private int _id;
    private String _name;
    private String _description;
    private boolean deleted;
    private List<PlaylistItem> _items;

    public Playlist(Library library) {
        super(new PlaylistDB(((LibraryDB)library.db).getDatabase()));
        this._library = library;
        this._id = -2;
        this._items = new LinkedList<PlaylistItem>();
        this.deleted = false;
    }

    public Playlist(Library library, int n, String string, String string2) {
        super(new PlaylistDB(((LibraryDB)library.db).getDatabase()));
        this._library = library;
        this._id = n;
        this._name = string;
        this._description = string2;
        this._items = new LinkedList<PlaylistItem>();
        this.deleted = false;
    }

    public boolean isStarred() {
        return this._id == -3;
    }

    public Library getLibrary() {
        return this._library;
    }

    public int getId() {
        return this._id;
    }

    public void setId(int n) {
        this._id = n;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public List<PlaylistItem> getItems() {
        return this._items;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public synchronized void save() {
        if (this.db != null) {
            ((PlaylistDB)this.db).save(this);
        }
    }

    public synchronized void delete() {
        if (this.db != null) {
            ((PlaylistDB)this.db).delete(this);
            this.deleted = true;
        }
    }

    public synchronized void refresh() {
        if (this.db != null) {
            this._items.clear();
            this._items.addAll(((PlaylistDB)this.db).getLibraryItems(this));
        }
    }

    public PlaylistItem newItem(String string, String string2, long l, String string3, String string4, float f, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, boolean bl) {
        return new PlaylistItem(this, -1, string, string2, l, string3, string4, f, string5, string6, string7, string8, string9, string10, string11, string12, bl);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Playlist)) {
            return false;
        }
        Playlist playlist = (Playlist)object;
        return playlist.getId() == this.getId();
    }
}

