/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.db.LibraryDatabase;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;

public class DumpDatabase {
    private static final String TABLE_SEPARATOR = "------------------------------------------------------------------------------";
    private final LibraryDatabase db;
    private final File file;

    public DumpDatabase(LibraryDatabase libraryDatabase, File file) {
        this.db = libraryDatabase;
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(this.file);
            this.dumpPlaylists(printWriter);
            this.dumpPlaylistItems(printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private void dumpTable(PrintWriter printWriter, String string, String string2) {
        List<List<Object>> list = this.db.query("SELECT " + string + " FROM " + string2, new Object[0]);
        printWriter.println(string);
        this.dumpRows(printWriter, list);
        printWriter.println(TABLE_SEPARATOR);
    }

    private void dumpRows(PrintWriter printWriter, List<List<Object>> list) {
        for (List<Object> list2 : list) {
            this.dumpRow(printWriter, list2);
        }
    }

    private void dumpRow(PrintWriter printWriter, List<Object> list) {
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            printWriter.print(list.get(i));
            printWriter.print(", ");
        }
        printWriter.print(list.get(n));
        printWriter.println();
    }

    private void dumpPlaylists(PrintWriter printWriter) {
        String string = "playlistId, name, description";
        this.dumpTable(printWriter, string, "Playlists");
    }

    private void dumpPlaylistItems(PrintWriter printWriter) {
        String string = "playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, duration, artistName, albumName, coverArtPath, bitrate, comment, genre, track, year";
        this.dumpTable(printWriter, string, "PlaylistItems");
    }
}

