/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.InternetRadioStation;
import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.InternetRadioStationDB;
import com.frostwire.alexandria.db.InternetRadioStationsData;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.ObjectDB;
import com.frostwire.alexandria.db.PlaylistDB;
import com.frostwire.alexandria.db.PlaylistItemDB;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class LibraryDB
extends ObjectDB<Library> {
    public LibraryDB(LibraryDatabase libraryDatabase) {
        super(libraryDatabase);
    }

    @Override
    public void fill(Library library) {
        List<List<Object>> list = this.db.query("SELECT libraryId, name, version FROM Library", new Object[0]);
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            this.fill(list2, library);
        }
    }

    @Override
    public void fill(List<Object> list, Library library) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        int n2 = (Integer)list.get(2);
        library.setId(n);
        library.setName(string);
        library.setVersion(n2);
    }

    @Override
    public void save(Library library) {
    }

    @Override
    public void delete(Library library) {
    }

    public List<Playlist> getPlaylists(Library library) {
        List<List<Object>> list = this.db.query("SELECT playlistId, name, description FROM Playlists", new Object[0]);
        ArrayList<Playlist> arrayList = new ArrayList<Playlist>(list.size());
        for (List<Object> list2 : list) {
            Playlist playlist = new Playlist(library);
            ((PlaylistDB)playlist.getDB()).fill(list2, playlist);
            arrayList.add(playlist);
        }
        return arrayList;
    }

    public Playlist getPlaylist(Library library, String string) {
        List<List<Object>> list = this.db.query("SELECT playlistId, name, description FROM Playlists WHERE name = ?", string);
        Playlist playlist = null;
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            playlist = new Playlist(library);
            ((PlaylistDB)playlist.getDB()).fill(list2, playlist);
        }
        return playlist;
    }

    public List<InternetRadioStation> getInternetRadioStations(Library library) {
        List<List<Object>> list = this.db.query("SELECT internetRadioStationId, name, description, url, bitrate, type, website, genre, pls, bookmarked FROM InternetRadioStations", new Object[0]);
        ArrayList<InternetRadioStation> arrayList = new ArrayList<InternetRadioStation>(list.size());
        for (List<Object> list2 : list) {
            InternetRadioStation internetRadioStation = new InternetRadioStation(library);
            ((InternetRadioStationDB)internetRadioStation.getDB()).fill(list2, internetRadioStation);
            arrayList.add(internetRadioStation);
        }
        return arrayList;
    }

    public Playlist getStarredPlaylist(Library library) {
        String string = "SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred FROM PlaylistItems WHERE starred = ?";
        List<List<Object>> list = this.db.query(string, true);
        Playlist playlist = new Playlist(library, -3, "starred", "starred");
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(list.size());
        HashSet<String> hashSet = new HashSet<String>();
        for (List<Object> list2 : list) {
            PlaylistItem playlistItem = new PlaylistItem(playlist);
            ((PlaylistItemDB)playlistItem.getDB()).fill(list2, playlistItem);
            if (hashSet.contains(playlistItem.getFilePath())) continue;
            arrayList.add(playlistItem);
            hashSet.add(playlistItem.getFilePath());
        }
        playlist.getItems().addAll(arrayList);
        return playlist;
    }

    public void updatePlaylistItemProperties(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        Object[] objectArray = this.createPlaylistItemPropertiesUpdate(string, string2, string3, string4, string5, string6, string7, string8);
        this.db.update((String)objectArray[0], (Object[])objectArray[1]);
    }

    private Object[] createPlaylistItemPropertiesUpdate(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        String string9 = "UPDATE PlaylistItems SET trackTitle = LEFT(?, 500), trackArtist = LEFT(?, 500), trackAlbum = LEFT(?, 500), trackComment = LEFT(?, 500), trackGenre = LEFT(?, 20), trackNumber = LEFT(?, 6), trackYear = LEFT(?, 6) WHERE filePath = LEFT(?, 10000)";
        Object[] objectArray = new Object[]{string2, string3, string4, string5, string6, string7, string8, string};
        return new Object[]{string9, objectArray};
    }

    public long getTotalRadioStations(Library library) {
        List<List<Object>> list = this.db.query("SELECT COUNT(*) FROM InternetRadioStations", new Object[0]);
        return list.size() > 0 ? (Long)list.get(0).get(0) : 0L;
    }

    public void restoreDefaultRadioStations(Library library) {
        List<InternetRadioStation> list = this.getInternetRadioStations(library);
        InternetRadioStationsData internetRadioStationsData = new InternetRadioStationsData();
        for (InternetRadioStation object : list) {
            internetRadioStationsData.add(object.getName(), object.getDescription(), object.getUrl(), object.getBitrate(), object.getType(), object.getWebsite(), object.getGenre(), object.getPls());
        }
        this.db.update("DELETE FROM InternetRadioStations", new Object[0]);
        for (List list2 : internetRadioStationsData.getData()) {
            this.db.update("INSERT INTO InternetRadioStations (name, description, url, bitrate, type, website, genre, pls, bookmarked) VALUES (LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100), LEFT(?, 100), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100000), false)", list2.toArray());
        }
    }
}

