/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.db.DumpDatabase;
import com.frostwire.alexandria.db.InternetRadioStationsData;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class LibraryDatabase {
    public static final int OBJECT_NOT_SAVED_ID = -1;
    public static final int OBJECT_INVALID_ID = -2;
    public static final int STARRED_PLAYLIST_ID = -3;
    public static final int LIBRARY_DATABASE_VERSION = 3;
    private final File _databaseFile;
    private final String _name;
    private Connection _connection;
    private boolean _closed;

    public LibraryDatabase(File file) {
        this._databaseFile = file;
        File file2 = file;
        this._name = file.getName();
        this._connection = this.openOrCreateDatabase(file2, this._name);
    }

    public File getDatabaseFile() {
        return this._databaseFile;
    }

    public String getName() {
        return this._name;
    }

    public boolean isClosed() {
        return this._closed;
    }

    public synchronized List<List<Object>> query(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return new ArrayList<List<Object>>();
        }
        return this.query(this._connection, string, objectArray);
    }

    public synchronized int update(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return -1;
        }
        return this.update(this._connection, string, objectArray);
    }

    public synchronized int insert(String string, Object ... objectArray) {
        if (this.isClosed()) {
            return -2;
        }
        if (!string.toUpperCase().startsWith("INSERT")) {
            return -2;
        }
        if (this.update(string, objectArray) != -1) {
            return this.getIdentity();
        }
        return -2;
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this._closed = true;
        try {
            Statement statement = this._connection.createStatement();
            statement.execute("SHUTDOWN");
            this._connection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void dump() {
        if (this.isClosed()) {
            return;
        }
        try {
            new DumpDatabase(this, new File(this._databaseFile, "dump.txt")).dump();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Connection onUpdateDatabase(Connection connection, int n, int n2) {
        if (n == 1 && n2 > 2) {
            this.setupInternetRadioStationsTable(connection);
            this.setupLuceneIndex(connection);
        }
        if (n == 2 && n2 == 3) {
            this.setupLuceneIndex(connection);
        }
        this.update(connection, "UPDATE Library SET version = ?", 3);
        return connection;
    }

    private Connection openConnection(File file, String string, boolean bl) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("jdbc:h2:");
            stringBuilder.append(new File(file, string).getAbsolutePath());
            if (!bl) {
                stringBuilder.append(";ifexists=true");
            }
            return DriverManager.getConnection(stringBuilder.toString(), "SA", "");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Connection createDatabase(File file, String string) {
        Connection connection = this.openConnection(file, string, true);
        this.update(connection, "CREATE TABLE Library (libraryId INTEGER IDENTITY, name VARCHAR(500), version INTEGER)", new Object[0]);
        this.update(connection, "CREATE TABLE Playlists (playlistId INTEGER IDENTITY, name VARCHAR(500), description VARCHAR(10000))", new Object[0]);
        this.update(connection, "CREATE INDEX idx_Playlists_name ON Playlists (name)", new Object[0]);
        this.update(connection, "CREATE TABLE PlaylistItems (playlistItemId INTEGER IDENTITY, filePath VARCHAR(10000), fileName VARCHAR(500), fileSize BIGINT, fileExtension VARCHAR(10), trackTitle VARCHAR(500), trackDurationInSecs REAL, trackArtist VARCHAR(500), trackAlbum VARCHAR(500), coverArtPath VARCHAR(10000), trackBitrate VARCHAR(10), trackComment VARCHAR(500), trackGenre VARCHAR(20), trackNumber VARCHAR(6), trackYear VARCHAR(6), playlistId INTEGER, starred BOOLEAN)", new Object[0]);
        this.update(connection, "CREATE INDEX idx_PlaylistItems_filePath ON PlaylistItems (filePath)", new Object[0]);
        this.update(connection, "CREATE INDEX idx_PlaylistItems_starred ON PlaylistItems (starred)", new Object[0]);
        this.setupInternetRadioStationsTable(connection);
        this.setupLuceneIndex(connection);
        this.update(connection, "INSERT INTO Library (name , version) VALUES (?, ?)", string, 3);
        return connection;
    }

    private Connection openOrCreateDatabase(File file, String string) {
        Connection connection = this.openConnection(file, string, false);
        if (connection == null) {
            return this.createDatabase(file, string);
        }
        int n = this.getDatabaseVersion(connection);
        if (n < 3) {
            return this.onUpdateDatabase(connection, n, 3);
        }
        return connection;
    }

    private List<List<Object>> convertResultSetToList(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        LinkedList<List<Object>> linkedList = new LinkedList<List<Object>>();
        while (resultSet.next()) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 1; i <= n; ++i) {
                arrayList.add(resultSet.getObject(i));
            }
            linkedList.add(arrayList);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdentity() {
        if (this.isClosed()) {
            return -2;
        }
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this._connection.createStatement();
            resultSet = statement.executeQuery("CALL IDENTITY()");
            resultSet.next();
            int n = resultSet.getInt(1);
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return -2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Object>> query(Connection connection, String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    preparedStatement.setObject(i + 1, objectArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            List<List<Object>> list = this.convertResultSetToList(resultSet);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return new ArrayList<List<Object>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(Connection connection, String string, Object ... objectArray) {
        PreparedStatement preparedStatement = null;
        try {
            int n;
            preparedStatement = connection.prepareStatement(string);
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    preparedStatement.setObject(n + 1, objectArray[n]);
                }
            }
            n = preparedStatement.executeUpdate();
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return -1;
    }

    private int getDatabaseVersion(Connection connection) {
        List<List<Object>> list = this.query(connection, "SELECT version FROM Library", new Object[0]);
        return list.size() > 0 ? (Integer)list.get(0).get(0) : -1;
    }

    private void setupInternetRadioStationsTable(Connection connection) {
        this.update(connection, "CREATE TABLE InternetRadioStations (internetRadioStationId INTEGER IDENTITY, name VARCHAR(10000), description VARCHAR(10000), url VARCHAR(10000), bitrate VARCHAR(100), type VARCHAR(100), website VARCHAR(10000), genre VARCHAR(10000), pls VARCHAR(100000), bookmarked BOOLEAN)", new Object[0]);
        this.update(connection, "CREATE INDEX idx_InternetRadioStations_name ON InternetRadioStations (name)", new Object[0]);
        InternetRadioStationsData internetRadioStationsData = new InternetRadioStationsData();
        for (List<Object> list : internetRadioStationsData.getData()) {
            this.update(connection, "INSERT INTO InternetRadioStations (name, description, url, bitrate, type, website, genre, pls, bookmarked) VALUES (LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100), LEFT(?, 100), LEFT(?, 10000), LEFT(?, 10000), LEFT(?, 100000), false)", list.toArray());
        }
    }

    private void setupLuceneIndex(Connection connection) {
        this.update(connection, "CREATE ALIAS IF NOT EXISTS FTL_INIT FOR \"org.h2.fulltext.FullTextLucene2.init\"", new Object[0]);
        this.update(connection, "CALL FTL_INIT()", new Object[0]);
        this.update(connection, "CALL FTL_CREATE_INDEX('PUBLIC', 'PLAYLISTITEMS', 'FILEPATH, TRACKTITLE, TRACKARTIST, TRACKALBUM, TRACKGENRE, TRACKYEAR')", new Object[0]);
        this.update(connection, "CALL FTL_CREATE_INDEX('PUBLIC', 'INTERNETRADIOSTATIONS', 'NAME, DESCRIPTION, GENRE')", new Object[0]);
    }

    static {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }
}

