/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.ObjectDB;
import com.frostwire.alexandria.db.PlaylistItemDB;
import java.util.ArrayList;
import java.util.List;

public class PlaylistDB
extends ObjectDB<Playlist> {
    public PlaylistDB(LibraryDatabase libraryDatabase) {
        super(libraryDatabase);
    }

    @Override
    public void fill(Playlist playlist) {
        List<List<Object>> list = this.db.query("SELECT playlistId, name, description FROM Playlists WHERE playlistId = ?", playlist.getId());
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            this.fill(list2, playlist);
        }
    }

    @Override
    public void fill(List<Object> list, Playlist playlist) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        String string2 = (String)list.get(2);
        playlist.setId(n);
        playlist.setName(string);
        playlist.setDescription(string2);
    }

    @Override
    public void save(Playlist playlist) {
        if (playlist.getId() == -2) {
            return;
        }
        if (playlist.getId() == -1) {
            int n = this.db.insert("INSERT INTO Playlists (name, description) VALUES (LEFT(?, 500), LEFT(?, 10000))", playlist.getName(), playlist.getDescription());
            playlist.setId(n);
        } else {
            this.db.update("DELETE FROM PlaylistItems WHERE playlistId = ?", playlist.getId());
            Object[] objectArray = this.createPlaylistUpdateStatement(playlist);
            this.db.update((String)objectArray[0], (Object[])objectArray[1]);
        }
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(playlist.getItems());
        for (PlaylistItem playlistItem : arrayList) {
            playlistItem.setId(-1);
            playlistItem.save();
        }
    }

    @Override
    public void delete(Playlist playlist) {
        this.db.update("DELETE FROM PlaylistItems WHERE playlistId = ?", playlist.getId());
        this.db.update("DELETE FROM Playlists WHERE playlistId = ?", playlist.getId());
    }

    public List<PlaylistItem> getLibraryItems(Playlist playlist) {
        String string = "SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred FROM PlaylistItems WHERE playlistId = ?";
        List<List<Object>> list = this.db.query(string, playlist.getId());
        ArrayList<PlaylistItem> arrayList = new ArrayList<PlaylistItem>(list.size());
        for (List<Object> list2 : list) {
            PlaylistItem playlistItem = new PlaylistItem(playlist);
            ((PlaylistItemDB)playlistItem.getDB()).fill(list2, playlistItem);
            arrayList.add(playlistItem);
        }
        return arrayList;
    }

    private Object[] createPlaylistUpdateStatement(Playlist playlist) {
        String string = "UPDATE Playlists SET name = LEFT(?, 500), description = LEFT(?, 10000) WHERE playlistId = ?";
        Object[] objectArray = new Object[]{playlist.getName(), playlist.getDescription(), playlist.getId()};
        return new Object[]{string, objectArray};
    }
}

