/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.alexandria.db.LibraryDatabase;
import com.frostwire.alexandria.db.ObjectDB;
import java.util.List;

public class PlaylistItemDB
extends ObjectDB<PlaylistItem> {
    public PlaylistItemDB(LibraryDatabase libraryDatabase) {
        super(libraryDatabase);
    }

    @Override
    public void fill(PlaylistItem playlistItem) {
        List<List<Object>> list = this.db.query("SELECT playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred FROM PlaylistItems WHERE playlistItemId = ?", playlistItem.getId());
        if (list.size() > 0) {
            List<Object> list2 = list.get(0);
            this.fill(list2, playlistItem);
        }
    }

    @Override
    public void fill(List<Object> list, PlaylistItem playlistItem) {
        int n = (Integer)list.get(0);
        String string = (String)list.get(1);
        String string2 = (String)list.get(2);
        long l = (Long)list.get(3);
        String string3 = (String)list.get(4);
        String string4 = (String)list.get(5);
        float f = ((Float)list.get(6)).floatValue();
        String string5 = (String)list.get(7);
        String string6 = (String)list.get(8);
        String string7 = (String)list.get(9);
        String string8 = (String)list.get(10);
        String string9 = (String)list.get(11);
        String string10 = (String)list.get(12);
        String string11 = (String)list.get(13);
        String string12 = (String)list.get(14);
        boolean bl = (Boolean)list.get(15);
        playlistItem.setId(n);
        playlistItem.setFilePath(string);
        playlistItem.setFileName(string2);
        playlistItem.setFileSize(l);
        playlistItem.setFileExtension(string3);
        playlistItem.setTrackTitle(string4);
        playlistItem.setTrackDurationInSecs(f);
        playlistItem.setTrackArtist(string5);
        playlistItem.setTrackAlbum(string6);
        playlistItem.setCoverArtPath(string7);
        playlistItem.setTrackBitrate(string8);
        playlistItem.setTrackComment(string9);
        playlistItem.setTrackGenre(string10);
        playlistItem.setTrackNumber(string11);
        playlistItem.setTrackYear(string12);
        playlistItem.setStarred(bl);
    }

    @Override
    public void save(PlaylistItem playlistItem) {
        if (playlistItem.getId() == -2 || playlistItem.getPlaylist() == null) {
            return;
        }
        if (playlistItem.getId() == -1) {
            playlistItem.setStarred(this.isStarred(playlistItem) || playlistItem.isStarred());
            Object[] objectArray = this.createPlaylistItemInsert(playlistItem);
            int n = this.db.insert((String)objectArray[0], (Object[])objectArray[1]);
            playlistItem.setId(n);
            objectArray = this.updateStarred(playlistItem);
            this.db.update((String)objectArray[0], (Object[])objectArray[1]);
        } else {
            Object[] objectArray = this.createPlaylistItemUpdate(playlistItem);
            this.db.update((String)objectArray[0], (Object[])objectArray[1]);
            objectArray = this.updateStarred(playlistItem);
            this.db.update((String)objectArray[0], (Object[])objectArray[1]);
        }
    }

    @Override
    public void delete(PlaylistItem playlistItem) {
        this.db.update("DELETE FROM PlaylistItems WHERE playlistItemId = ?", playlistItem.getId());
    }

    private Object[] createPlaylistItemInsert(PlaylistItem playlistItem) {
        String string = "INSERT INTO PlaylistItems (playlistId, filePath, fileName, fileSize, fileExtension, trackTitle, trackDurationInSecs, trackArtist, trackAlbum, coverArtPath, trackBitrate, trackComment, trackGenre, trackNumber, trackYear, starred)  VALUES (?, LEFT(?, 10000), LEFT(?, 500), ?, LEFT(?, 10), LEFT(?, 500), ?, LEFT(?, 500), LEFT(?, 500), LEFT(?, 10000), LEFT(?, 10), LEFT(?, 500), LEFT(?, 20), LEFT(?, 6), LEFT(?, 6), ?)";
        Object[] objectArray = new Object[]{playlistItem.getPlaylist().getId(), playlistItem.getFilePath(), playlistItem.getFileName(), playlistItem.getFileSize(), playlistItem.getFileExtension(), playlistItem.getTrackTitle(), Float.valueOf(playlistItem.getTrackDurationInSecs()), playlistItem.getTrackArtist(), playlistItem.getTrackAlbum(), playlistItem.getCoverArtPath(), playlistItem.getTrackBitrate(), playlistItem.getTrackComment(), playlistItem.getTrackGenre(), playlistItem.getTrackNumber(), playlistItem.getTrackYear(), playlistItem.isStarred()};
        return new Object[]{string, objectArray};
    }

    private Object[] createPlaylistItemUpdate(PlaylistItem playlistItem) {
        String string = "UPDATE PlaylistItems SET filePath = LEFT(?, 10000), fileName = LEFT(?, 500), fileSize = ?, fileExtension = LEFT(?, 10), trackTitle = LEFT(?, 500), trackDurationInSecs = ?, trackArtist = LEFT(?, 500), trackAlbum = LEFT(?, 500), coverArtPath = LEFT(?, 10000), trackBitrate = LEFT(?, 10), trackComment = LEFT(?, 500), trackGenre = LEFT(?, 20), trackNumber = LEFT(?, 6), trackYear = LEFT(?, 6), starred = ? WHERE playlistItemId = ?";
        Object[] objectArray = new Object[]{playlistItem.getFilePath(), playlistItem.getFileName(), playlistItem.getFileSize(), playlistItem.getFileExtension(), playlistItem.getTrackTitle(), Float.valueOf(playlistItem.getTrackDurationInSecs()), playlistItem.getTrackArtist(), playlistItem.getTrackAlbum(), playlistItem.getCoverArtPath(), playlistItem.getTrackBitrate(), playlistItem.getTrackComment(), playlistItem.getTrackGenre(), playlistItem.getTrackNumber(), playlistItem.getTrackYear(), playlistItem.isStarred(), playlistItem.getId()};
        return new Object[]{string, objectArray};
    }

    private Object[] updateStarred(PlaylistItem playlistItem) {
        String string = "UPDATE PlaylistItems SET starred = ? WHERE filePath = LEFT(?, 10000)";
        Object[] objectArray = new Object[]{playlistItem.isStarred(), playlistItem.getFilePath()};
        return new Object[]{string, objectArray};
    }

    private boolean isStarred(PlaylistItem playlistItem) {
        List<List<Object>> list = this.db.query("SELECT starred FROM PlaylistItems WHERE filePath = ? LIMIT 1", playlistItem.getFilePath());
        if (list.size() > 0) {
            return (Boolean)list.get(0).get(0);
        }
        return false;
    }
}

