/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.CharArrayMap;
import org.apache.lucene.util.Version;

public class CharArraySet
extends AbstractSet<Object> {
    public static final CharArraySet EMPTY_SET = new CharArraySet(CharArrayMap.<Object>emptyMap());
    private static final Object PLACEHOLDER = new Object();
    private final CharArrayMap<Object> map;

    public CharArraySet(Version version, int n, boolean bl) {
        this(new CharArrayMap<Object>(version, n, bl));
    }

    public CharArraySet(Version version, Collection<?> collection, boolean bl) {
        this(version, collection.size(), bl);
        this.addAll(collection);
    }

    @Deprecated
    public CharArraySet(int n, boolean bl) {
        this(Version.LUCENE_30, n, bl);
    }

    @Deprecated
    public CharArraySet(Collection<?> collection, boolean bl) {
        this(Version.LUCENE_30, collection.size(), bl);
        this.addAll(collection);
    }

    CharArraySet(CharArrayMap<Object> charArrayMap) {
        this.map = charArrayMap;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public boolean contains(char[] cArray, int n, int n2) {
        return this.map.containsKey(cArray, n, n2);
    }

    public boolean contains(CharSequence charSequence) {
        return this.map.containsKey(charSequence);
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(Object object) {
        return this.map.put(object, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(CharSequence charSequence) {
        return this.map.put(charSequence, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(String string) {
        return this.map.put(string, PLACEHOLDER) == null;
    }

    @Override
    public boolean add(char[] cArray) {
        return this.map.put(cArray, PLACEHOLDER) == null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public static CharArraySet unmodifiableSet(CharArraySet charArraySet) {
        if (charArraySet == null) {
            throw new NullPointerException("Given set is null");
        }
        if (charArraySet == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (charArraySet.map instanceof CharArrayMap.UnmodifiableCharArrayMap) {
            return charArraySet;
        }
        return new CharArraySet(CharArrayMap.unmodifiableMap(charArraySet.map));
    }

    @Deprecated
    public static CharArraySet copy(Set<?> set) {
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        return CharArraySet.copy(Version.LUCENE_30, set);
    }

    public static CharArraySet copy(Version version, Set<?> set) {
        if (set == EMPTY_SET) {
            return EMPTY_SET;
        }
        if (set instanceof CharArraySet) {
            CharArraySet charArraySet = (CharArraySet)set;
            return new CharArraySet(CharArrayMap.copy(charArraySet.map.matchVersion, charArraySet.map));
        }
        return new CharArraySet(version, set, false);
    }

    @Deprecated
    public Iterator<String> stringIterator() {
        return new CharArraySetIterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.map.matchVersion.onOrAfter(Version.LUCENE_31) ? this.map.originalKeySet().iterator() : this.stringIterator();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        for (Object object : this) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            if (object instanceof char[]) {
                stringBuilder.append((char[])object);
                continue;
            }
            stringBuilder.append(object);
        }
        return stringBuilder.append(']').toString();
    }

    @Deprecated
    public class CharArraySetIterator
    implements Iterator<String> {
        int pos = -1;
        char[] next;

        private CharArraySetIterator() {
            this.goNext();
        }

        private void goNext() {
            this.next = null;
            ++this.pos;
            while (this.pos < ((CharArraySet)CharArraySet.this).map.keys.length && (this.next = ((CharArraySet)CharArraySet.this).map.keys[this.pos]) == null) {
                ++this.pos;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public char[] nextCharArray() {
            char[] cArray = this.next;
            this.goNext();
            return cArray;
        }

        @Override
        public String next() {
            return new String(this.nextCharArray());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

