/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final Set<?> ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer(Version version) {
        this(version, ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(Version version, Set<?> set) {
        super(version, set);
    }

    public StopAnalyzer(Version version, File file) throws IOException {
        this(version, WordlistLoader.getWordSet(IOUtils.getDecodingReader(file, IOUtils.CHARSET_UTF_8), version));
    }

    public StopAnalyzer(Version version, Reader reader) throws IOException {
        this(version, WordlistLoader.getWordSet(reader, version));
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String string, Reader reader) {
        LowerCaseTokenizer lowerCaseTokenizer = new LowerCaseTokenizer(this.matchVersion, reader);
        return new ReusableAnalyzerBase.TokenStreamComponents(lowerCaseTokenizer, new StopFilter(this.matchVersion, (TokenStream)lowerCaseTokenizer, this.stopwords));
    }

    static {
        List<String> list = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet charArraySet = new CharArraySet(Version.LUCENE_CURRENT, list.size(), false);
        charArraySet.addAll(list);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(charArraySet);
    }
}

