/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class CharTermAttributeImpl
extends AttributeImpl
implements CharTermAttribute,
TermAttribute,
Cloneable,
Serializable {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;

    @Override
    @Deprecated
    public String term() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public final void copyBuffer(char[] cArray, int n, int n2) {
        this.growTermBuffer(n2);
        System.arraycopy(cArray, n, this.termBuffer, 0, n2);
        this.termLength = n2;
    }

    @Override
    @Deprecated
    public void setTermBuffer(char[] cArray, int n, int n2) {
        this.copyBuffer(cArray, n, n2);
    }

    @Override
    @Deprecated
    public void setTermBuffer(String string) {
        int n = string.length();
        this.growTermBuffer(n);
        string.getChars(0, n, this.termBuffer, 0);
        this.termLength = n;
    }

    @Override
    @Deprecated
    public void setTermBuffer(String string, int n, int n2) {
        assert (n <= string.length());
        assert (n + n2 <= string.length());
        this.growTermBuffer(n2);
        string.getChars(n, n + n2, this.termBuffer, 0);
        this.termLength = n2;
    }

    @Override
    public final char[] buffer() {
        return this.termBuffer;
    }

    @Override
    @Deprecated
    public char[] termBuffer() {
        return this.termBuffer;
    }

    @Override
    public final char[] resizeBuffer(int n) {
        if (this.termBuffer.length < n) {
            char[] cArray = new char[ArrayUtil.oversize(n, 2)];
            System.arraycopy(this.termBuffer, 0, cArray, 0, this.termBuffer.length);
            this.termBuffer = cArray;
        }
        return this.termBuffer;
    }

    @Override
    @Deprecated
    public char[] resizeTermBuffer(int n) {
        return this.resizeBuffer(n);
    }

    private void growTermBuffer(int n) {
        if (this.termBuffer.length < n) {
            this.termBuffer = new char[ArrayUtil.oversize(n, 2)];
        }
    }

    @Override
    @Deprecated
    public int termLength() {
        return this.termLength;
    }

    @Override
    public final CharTermAttribute setLength(int n) {
        if (n > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + n + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = n;
        return this;
    }

    @Override
    public final CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Override
    @Deprecated
    public void setTermLength(int n) {
        this.setLength(n);
    }

    @Override
    public final int length() {
        return this.termLength;
    }

    @Override
    public final char charAt(int n) {
        if (n >= this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.termBuffer[n];
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        if (n > this.termLength || n2 > this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termBuffer, n, n2 - n);
    }

    @Override
    public final CharTermAttribute append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public final CharTermAttribute append(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            charSequence = "null";
        }
        int n3 = n2 - n;
        int n4 = charSequence.length();
        if (n3 < 0 || n > n4 || n2 > n4) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return this;
        }
        this.resizeBuffer(this.termLength + n3);
        if (n3 > 4) {
            if (charSequence instanceof String) {
                ((String)charSequence).getChars(n, n2, this.termBuffer, this.termLength);
            } else if (charSequence instanceof StringBuilder) {
                ((StringBuilder)charSequence).getChars(n, n2, this.termBuffer, this.termLength);
            } else if (charSequence instanceof CharTermAttribute) {
                System.arraycopy(((CharTermAttribute)charSequence).buffer(), n, this.termBuffer, this.termLength, n3);
            } else if (charSequence instanceof CharBuffer && ((CharBuffer)charSequence).hasArray()) {
                CharBuffer charBuffer = (CharBuffer)charSequence;
                System.arraycopy(charBuffer.array(), charBuffer.arrayOffset() + charBuffer.position() + n, this.termBuffer, this.termLength, n3);
            } else if (charSequence instanceof StringBuffer) {
                ((StringBuffer)charSequence).getChars(n, n2, this.termBuffer, this.termLength);
            } else {
                while (n < n2) {
                    this.termBuffer[this.termLength++] = charSequence.charAt(n++);
                }
                return this;
            }
            this.termLength += n3;
            return this;
        }
        while (n < n2) {
            this.termBuffer[this.termLength++] = charSequence.charAt(n++);
        }
        return this;
    }

    @Override
    public final CharTermAttribute append(char c) {
        this.resizeBuffer((int)(this.termLength + 1))[this.termLength++] = c;
        return this;
    }

    @Override
    public final CharTermAttribute append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n = string.length();
        string.getChars(0, n, this.resizeBuffer(this.termLength + n), this.termLength);
        this.termLength += n;
        return this;
    }

    @Override
    public final CharTermAttribute append(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            return this.appendNull();
        }
        int n = stringBuilder.length();
        stringBuilder.getChars(0, n, this.resizeBuffer(this.termLength + n), this.termLength);
        this.termLength += n;
        return this;
    }

    @Override
    public final CharTermAttribute append(CharTermAttribute charTermAttribute) {
        if (charTermAttribute == null) {
            return this.appendNull();
        }
        int n = charTermAttribute.length();
        System.arraycopy(charTermAttribute.buffer(), 0, this.resizeBuffer(this.termLength + n), this.termLength, n);
        this.termLength += n;
        return this;
    }

    private CharTermAttribute appendNull() {
        this.resizeBuffer(this.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        int n = this.termLength;
        n = n * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
        return n;
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    @Override
    public Object clone() {
        CharTermAttributeImpl charTermAttributeImpl = (CharTermAttributeImpl)super.clone();
        charTermAttributeImpl.termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, charTermAttributeImpl.termBuffer, 0, this.termLength);
        return charTermAttributeImpl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CharTermAttributeImpl) {
            CharTermAttributeImpl charTermAttributeImpl = (CharTermAttributeImpl)object;
            if (this.termLength != charTermAttributeImpl.termLength) {
                return false;
            }
            for (int i = 0; i < this.termLength; ++i) {
                if (this.termBuffer[i] == charTermAttributeImpl.termBuffer[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(AttributeReflector attributeReflector) {
        attributeReflector.reflect(CharTermAttribute.class, "term", this.toString());
    }

    @Override
    public void copyTo(AttributeImpl attributeImpl) {
        if (attributeImpl instanceof CharTermAttribute) {
            CharTermAttribute charTermAttribute = (CharTermAttribute)((Object)attributeImpl);
            charTermAttribute.copyBuffer(this.termBuffer, 0, this.termLength);
        } else {
            TermAttribute termAttribute = (TermAttribute)((Object)attributeImpl);
            termAttribute.setTermBuffer(this.termBuffer, 0, this.termLength);
        }
    }
}

