/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public final class Document
implements Serializable {
    List<Fieldable> fields = new ArrayList<Fieldable>();
    private float boost = 1.0f;
    private static final Field[] NO_FIELDS = new Field[0];
    private static final Fieldable[] NO_FIELDABLES = new Fieldable[0];
    private static final String[] NO_STRINGS = new String[0];
    private static final byte[][] NO_BYTES = new byte[0][];

    public void setBoost(float f) {
        this.boost = f;
    }

    public float getBoost() {
        return this.boost;
    }

    public final void add(Fieldable fieldable) {
        this.fields.add(fieldable);
    }

    public final void removeField(String string) {
        Iterator<Fieldable> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Fieldable fieldable = iterator.next();
            if (!fieldable.name().equals(string)) continue;
            iterator.remove();
            return;
        }
    }

    public final void removeFields(String string) {
        Iterator<Fieldable> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            Fieldable fieldable = iterator.next();
            if (!fieldable.name().equals(string)) continue;
            iterator.remove();
        }
    }

    @Deprecated
    public final Field getField(String string) {
        return (Field)this.getFieldable(string);
    }

    public Fieldable getFieldable(String string) {
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string)) continue;
            return fieldable;
        }
        return null;
    }

    public final String get(String string) {
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string) || fieldable.isBinary()) continue;
            return fieldable.stringValue();
        }
        return null;
    }

    public final List<Fieldable> getFields() {
        return this.fields;
    }

    @Deprecated
    public final Field[] getFields(String string) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string)) continue;
            arrayList.add((Field)fieldable);
        }
        if (arrayList.size() == 0) {
            return NO_FIELDS;
        }
        return arrayList.toArray(new Field[arrayList.size()]);
    }

    public Fieldable[] getFieldables(String string) {
        ArrayList<Fieldable> arrayList = new ArrayList<Fieldable>();
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string)) continue;
            arrayList.add(fieldable);
        }
        if (arrayList.size() == 0) {
            return NO_FIELDABLES;
        }
        return arrayList.toArray(new Fieldable[arrayList.size()]);
    }

    public final String[] getValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string) || fieldable.isBinary()) continue;
            arrayList.add(fieldable.stringValue());
        }
        if (arrayList.size() == 0) {
            return NO_STRINGS;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final byte[][] getBinaryValues(String string) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string) || !fieldable.isBinary()) continue;
            arrayList.add(fieldable.getBinaryValue());
        }
        if (arrayList.size() == 0) {
            return NO_BYTES;
        }
        return (byte[][])arrayList.toArray((T[])new byte[arrayList.size()][]);
    }

    public final byte[] getBinaryValue(String string) {
        for (Fieldable fieldable : this.fields) {
            if (!fieldable.name().equals(string) || !fieldable.isBinary()) continue;
            return fieldable.getBinaryValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            Fieldable fieldable = this.fields.get(i);
            stringBuilder.append(fieldable.toString());
            if (i == this.fields.size() - 1) continue;
            stringBuilder.append(" ");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

