/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.MultiLevelSkipListWriter;
import org.apache.lucene.store.IndexOutput;

class DefaultSkipListWriter
extends MultiLevelSkipListWriter {
    private int[] lastSkipDoc;
    private int[] lastSkipPayloadLength;
    private long[] lastSkipFreqPointer;
    private long[] lastSkipProxPointer;
    private IndexOutput freqOutput;
    private IndexOutput proxOutput;
    private int curDoc;
    private boolean curStorePayloads;
    private int curPayloadLength;
    private long curFreqPointer;
    private long curProxPointer;

    DefaultSkipListWriter(int n, int n2, int n3, IndexOutput indexOutput, IndexOutput indexOutput2) {
        super(n, n2, n3);
        this.freqOutput = indexOutput;
        this.proxOutput = indexOutput2;
        this.lastSkipDoc = new int[n2];
        this.lastSkipPayloadLength = new int[n2];
        this.lastSkipFreqPointer = new long[n2];
        this.lastSkipProxPointer = new long[n2];
    }

    void setFreqOutput(IndexOutput indexOutput) {
        this.freqOutput = indexOutput;
    }

    void setProxOutput(IndexOutput indexOutput) {
        this.proxOutput = indexOutput;
    }

    void setSkipData(int n, boolean bl, int n2) {
        this.curDoc = n;
        this.curStorePayloads = bl;
        this.curPayloadLength = n2;
        this.curFreqPointer = this.freqOutput.getFilePointer();
        if (this.proxOutput != null) {
            this.curProxPointer = this.proxOutput.getFilePointer();
        }
    }

    @Override
    protected void resetSkip() {
        super.resetSkip();
        Arrays.fill(this.lastSkipDoc, 0);
        Arrays.fill(this.lastSkipPayloadLength, -1);
        Arrays.fill(this.lastSkipFreqPointer, this.freqOutput.getFilePointer());
        if (this.proxOutput != null) {
            Arrays.fill(this.lastSkipProxPointer, this.proxOutput.getFilePointer());
        }
    }

    @Override
    protected void writeSkipData(int n, IndexOutput indexOutput) throws IOException {
        if (this.curStorePayloads) {
            int n2 = this.curDoc - this.lastSkipDoc[n];
            if (this.curPayloadLength == this.lastSkipPayloadLength[n]) {
                indexOutput.writeVInt(n2 * 2);
            } else {
                indexOutput.writeVInt(n2 * 2 + 1);
                indexOutput.writeVInt(this.curPayloadLength);
                this.lastSkipPayloadLength[n] = this.curPayloadLength;
            }
        } else {
            indexOutput.writeVInt(this.curDoc - this.lastSkipDoc[n]);
        }
        indexOutput.writeVInt((int)(this.curFreqPointer - this.lastSkipFreqPointer[n]));
        indexOutput.writeVInt((int)(this.curProxPointer - this.lastSkipProxPointer[n]));
        this.lastSkipDoc[n] = this.curDoc;
        this.lastSkipFreqPointer[n] = this.curFreqPointer;
        this.lastSkipProxPointer[n] = this.curProxPointer;
    }
}

