/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.ReadOnlyDirectoryReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.MapBackedSet;

class DirectoryReader
extends IndexReader
implements Cloneable {
    protected Directory directory;
    protected boolean readOnly;
    IndexWriter writer;
    private IndexDeletionPolicy deletionPolicy;
    private Lock writeLock;
    private final SegmentInfos segmentInfos;
    private boolean stale;
    private final int termInfosIndexDivisor;
    private boolean rollbackHasChanges;
    private SegmentReader[] subReaders;
    private int[] starts;
    private Map<String, byte[]> normsCache = new HashMap<String, byte[]>();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private long maxIndexVersion;
    private final boolean applyAllDeletes;

    static IndexReader open(Directory directory, final IndexDeletionPolicy indexDeletionPolicy, IndexCommit indexCommit, final boolean bl, final int n) throws CorruptIndexException, IOException {
        return (IndexReader)new SegmentInfos.FindSegmentsFile(directory){

            @Override
            protected Object doBody(String string) throws CorruptIndexException, IOException {
                SegmentInfos segmentInfos = new SegmentInfos();
                segmentInfos.read(this.directory, string);
                if (bl) {
                    return new ReadOnlyDirectoryReader(this.directory, segmentInfos, indexDeletionPolicy, n, null);
                }
                return new DirectoryReader(this.directory, segmentInfos, indexDeletionPolicy, false, n, null);
            }
        }.run(indexCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(Directory directory, SegmentInfos segmentInfos, IndexDeletionPolicy indexDeletionPolicy, boolean bl, int n, Collection<IndexReader.ReaderFinishedListener> collection) throws IOException {
        this.directory = directory;
        this.readOnly = bl;
        this.segmentInfos = segmentInfos;
        this.deletionPolicy = indexDeletionPolicy;
        this.termInfosIndexDivisor = n;
        this.readerFinishedListeners = collection == null ? new MapBackedSet(new ConcurrentHashMap()) : collection;
        this.applyAllDeletes = false;
        SegmentReader[] segmentReaderArray = new SegmentReader[segmentInfos.size()];
        for (int i = segmentInfos.size() - 1; i >= 0; --i) {
            boolean bl2 = false;
            try {
                segmentReaderArray[i] = SegmentReader.get(bl, segmentInfos.info(i), n);
                segmentReaderArray[i].readerFinishedListeners = this.readerFinishedListeners;
                bl2 = true;
                continue;
            }
            finally {
                if (!bl2) {
                    ++i;
                    while (i < segmentInfos.size()) {
                        try {
                            segmentReaderArray[i].close();
                        }
                        catch (Throwable throwable) {}
                        ++i;
                    }
                }
            }
        }
        this.initialize(segmentReaderArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(IndexWriter indexWriter, SegmentInfos segmentInfos, int n, boolean bl) throws IOException {
        this.directory = indexWriter.getDirectory();
        this.readOnly = true;
        this.applyAllDeletes = bl;
        this.termInfosIndexDivisor = n;
        this.readerFinishedListeners = indexWriter.getReaderFinishedListeners();
        int n2 = segmentInfos.size();
        ArrayList<SegmentReader> arrayList = new ArrayList<SegmentReader>();
        Directory directory = indexWriter.getDirectory();
        this.segmentInfos = (SegmentInfos)segmentInfos.clone();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            boolean bl2 = false;
            try {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                assert (segmentInfo.dir == directory);
                SegmentReader segmentReader = indexWriter.readerPool.getReadOnlyClone(segmentInfo, true, n);
                if (segmentReader.numDocs() > 0 || indexWriter.getKeepFullyDeletedSegments()) {
                    segmentReader.readerFinishedListeners = this.readerFinishedListeners;
                    arrayList.add(segmentReader);
                    ++n3;
                } else {
                    segmentReader.close();
                    this.segmentInfos.remove(n3);
                }
                bl2 = true;
                continue;
            }
            finally {
                if (!bl2) {
                    for (SegmentReader segmentReader : arrayList) {
                        try {
                            segmentReader.close();
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        }
        this.writer = indexWriter;
        this.initialize(arrayList.toArray(new SegmentReader[arrayList.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(Directory directory, SegmentInfos segmentInfos, SegmentReader[] segmentReaderArray, int[] nArray, Map<String, byte[]> map, boolean bl, boolean bl2, int n, Collection<IndexReader.ReaderFinishedListener> collection) throws IOException {
        Object object;
        this.directory = directory;
        this.readOnly = bl;
        this.segmentInfos = segmentInfos;
        this.termInfosIndexDivisor = n;
        assert (collection != null);
        this.readerFinishedListeners = collection;
        this.applyAllDeletes = false;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (segmentReaderArray != null) {
            for (int i = 0; i < segmentReaderArray.length; ++i) {
                hashMap.put(segmentReaderArray[i].getSegmentName(), i);
            }
        }
        SegmentReader[] segmentReaderArray2 = new SegmentReader[segmentInfos.size()];
        boolean[] blArray = new boolean[segmentInfos.size()];
        for (int i = segmentInfos.size() - 1; i >= 0; --i) {
            Map.Entry<String, byte[]> entry = (Integer)hashMap.get(segmentInfos.info((int)i).name);
            segmentReaderArray2[i] = entry == null ? null : segmentReaderArray[(Integer)((Object)entry)];
            boolean bl3 = false;
            try {
                if (segmentReaderArray2[i] == null || segmentInfos.info(i).getUseCompoundFile() != segmentReaderArray2[i].getSegmentInfo().getUseCompoundFile()) {
                    assert (!bl2);
                    object = SegmentReader.get(bl, segmentInfos.info(i), n);
                    object.readerFinishedListeners = collection;
                    blArray[i] = false;
                    segmentReaderArray2[i] = object;
                } else {
                    object = segmentReaderArray2[i].reopenSegment(segmentInfos.info(i), bl2, bl);
                    if (object == null) {
                        blArray[i] = true;
                        segmentReaderArray2[i].incRef();
                    } else {
                        assert (object.readerFinishedListeners == collection);
                        blArray[i] = false;
                        segmentReaderArray2[i] = object;
                    }
                }
                bl3 = true;
                continue;
            }
            finally {
                if (!bl3) {
                    ++i;
                    while (i < segmentInfos.size()) {
                        if (segmentReaderArray2[i] != null) {
                            try {
                                if (!blArray[i]) {
                                    segmentReaderArray2[i].close();
                                } else {
                                    segmentReaderArray2[i].decRef();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                        ++i;
                    }
                }
            }
        }
        this.initialize(segmentReaderArray2);
        if (map != null) {
            for (Map.Entry<String, byte[]> entry : map.entrySet()) {
                String string = (String)entry.getKey();
                if (!this.hasNorms(string)) continue;
                object = (byte[])entry.getValue();
                byte[] byArray = new byte[this.maxDoc()];
                for (int i = 0; i < this.subReaders.length; ++i) {
                    Integer n2 = (Integer)hashMap.get(this.subReaders[i].getSegmentName());
                    if (n2 != null && (segmentReaderArray[n2] == this.subReaders[i] || segmentReaderArray[n2.intValue()].norms.get(string) == this.subReaders[i].norms.get(string))) {
                        System.arraycopy(object, nArray[n2], byArray, this.starts[i], this.starts[i + 1] - this.starts[i]);
                        continue;
                    }
                    this.subReaders[i].norms(string, byArray, this.starts[i]);
                }
                this.normsCache.put(string, byArray);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasChanges) {
            stringBuilder.append("*");
        }
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('(');
        String string = this.segmentInfos.getCurrentSegmentFileName();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (this.writer != null) {
            stringBuilder.append(":nrt");
        }
        for (int i = 0; i < this.subReaders.length; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(this.subReaders[i]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private void initialize(SegmentReader[] segmentReaderArray) throws IOException {
        this.subReaders = segmentReaderArray;
        this.starts = new int[segmentReaderArray.length + 1];
        for (int i = 0; i < segmentReaderArray.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += segmentReaderArray[i].maxDoc();
            if (!segmentReaderArray[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[segmentReaderArray.length] = this.maxDoc;
        if (!this.readOnly) {
            this.maxIndexVersion = SegmentInfos.readCurrentVersion(this.directory);
        }
    }

    @Override
    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public final synchronized IndexReader clone(boolean bl) throws CorruptIndexException, IOException {
        DirectoryReader directoryReader = this.doOpenIfChanged((SegmentInfos)this.segmentInfos.clone(), true, bl);
        if (this != directoryReader) {
            directoryReader.deletionPolicy = this.deletionPolicy;
        }
        directoryReader.writer = this.writer;
        if (!bl && this.writeLock != null) {
            assert (this.writer == null);
            directoryReader.writeLock = this.writeLock;
            directoryReader.hasChanges = this.hasChanges;
            directoryReader.hasDeletions = this.hasDeletions;
            this.writeLock = null;
            this.hasChanges = false;
        }
        assert (directoryReader.readerFinishedListeners != null);
        return directoryReader;
    }

    @Override
    protected final IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(this.readOnly, null);
    }

    @Override
    protected final IndexReader doOpenIfChanged(boolean bl) throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(bl, null);
    }

    @Override
    protected final IndexReader doOpenIfChanged(IndexCommit indexCommit) throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(true, indexCommit);
    }

    @Override
    protected final IndexReader doOpenIfChanged(IndexWriter indexWriter, boolean bl) throws CorruptIndexException, IOException {
        if (indexWriter == this.writer && bl == this.applyAllDeletes) {
            return this.doOpenIfChanged();
        }
        return super.doOpenIfChanged(indexWriter, bl);
    }

    private final IndexReader doOpenFromWriter(boolean bl, IndexCommit indexCommit) throws CorruptIndexException, IOException {
        assert (this.readOnly);
        if (!bl) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() can only be reopened with openReadOnly=true (got false)");
        }
        if (indexCommit != null) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() cannot currently accept a commit");
        }
        if (this.writer.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        IndexReader indexReader = this.writer.getReader(this.applyAllDeletes);
        if (indexReader.getVersion() == this.segmentInfos.getVersion()) {
            indexReader.decRef();
            return null;
        }
        indexReader.readerFinishedListeners = this.readerFinishedListeners;
        return indexReader;
    }

    private IndexReader doOpenIfChanged(boolean bl, IndexCommit indexCommit) throws CorruptIndexException, IOException {
        this.ensureOpen();
        assert (indexCommit == null || bl);
        if (this.writer != null) {
            return this.doOpenFromWriter(bl, indexCommit);
        }
        return this.doOpenNoWriter(bl, indexCommit);
    }

    private synchronized IndexReader doOpenNoWriter(final boolean bl, IndexCommit indexCommit) throws CorruptIndexException, IOException {
        if (indexCommit == null) {
            if (this.hasChanges) {
                assert (!this.readOnly);
                assert (this.writeLock != null);
                assert (this.isCurrent());
                if (bl) {
                    return this.clone(bl);
                }
                return null;
            }
            if (this.isCurrent()) {
                if (bl != this.readOnly) {
                    return this.clone(bl);
                }
                return null;
            }
        } else {
            if (this.directory != indexCommit.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && indexCommit.getSegmentsFileName().equals(this.segmentInfos.getCurrentSegmentFileName())) {
                if (this.readOnly != bl) {
                    return this.clone(bl);
                }
                return null;
            }
        }
        return (IndexReader)new SegmentInfos.FindSegmentsFile(this.directory){

            @Override
            protected Object doBody(String string) throws CorruptIndexException, IOException {
                SegmentInfos segmentInfos = new SegmentInfos();
                segmentInfos.read(this.directory, string);
                return DirectoryReader.this.doOpenIfChanged(segmentInfos, false, bl);
            }
        }.run(indexCommit);
    }

    private synchronized DirectoryReader doOpenIfChanged(SegmentInfos segmentInfos, boolean bl, boolean bl2) throws CorruptIndexException, IOException {
        DirectoryReader directoryReader = bl2 ? new ReadOnlyDirectoryReader(this.directory, segmentInfos, this.subReaders, this.starts, this.normsCache, bl, this.termInfosIndexDivisor, this.readerFinishedListeners) : new DirectoryReader(this.directory, segmentInfos, this.subReaders, this.starts, this.normsCache, false, bl, this.termInfosIndexDivisor, this.readerFinishedListeners);
        return directoryReader;
    }

    @Override
    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVectors(n - this.starts[n2]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVector(n - this.starts[n2], string);
    }

    @Override
    public void getTermFreqVector(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        this.subReaders[n2].getTermFreqVector(n - this.starts[n2], string, termVectorMapper);
    }

    @Override
    public void getTermFreqVector(int n, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        this.subReaders[n2].getTermFreqVector(n - this.starts[n2], termVectorMapper);
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    @Override
    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].document(n - this.starts[n2], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].isDeleted(n - this.starts[n2]);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int n2 = this.readerIndex(n);
        this.subReaders[n2].deleteDocument(n - this.starts[n2]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    static final int readerIndex(int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n4 >= n3) {
            int n5 = n3 + n4 >>> 1;
            int n6 = nArray[n5];
            if (n < n6) {
                n4 = n5 - 1;
                continue;
            }
            if (n > n6) {
                n3 = n5 + 1;
                continue;
            }
            while (n5 + 1 < n2 && nArray[n5 + 1] == n6) {
                ++n5;
            }
            return n5;
        }
        return n4;
    }

    @Override
    public boolean hasNorms(String string) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized byte[] norms(String string) throws IOException {
        this.ensureOpen();
        byte[] byArray = this.normsCache.get(string);
        if (byArray != null) {
            return byArray;
        }
        if (!this.hasNorms(string)) {
            return null;
        }
        byArray = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(string, byArray, this.starts[i]);
        }
        this.normsCache.put(string, byArray);
        return byArray;
    }

    @Override
    public synchronized void norms(String string, byte[] byArray, int n) throws IOException {
        this.ensureOpen();
        byte[] byArray2 = this.normsCache.get(string);
        if (byArray2 == null && !this.hasNorms(string)) {
            Arrays.fill(byArray, n, byArray.length, Similarity.getDefault().encodeNormValue(1.0f));
        } else if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, n, this.maxDoc());
        } else {
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].norms(string, byArray, n + this.starts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        Map<String, byte[]> map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(string);
        }
        int n2 = this.readerIndex(n);
        this.subReaders[n2].setNorm(n - this.starts[n2], string, by);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms();
        }
        return new MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms(term);
        }
        return new MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        int n = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            n += this.subReaders[i].docFreq(term);
        }
        return n;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs();
        }
        return new MultiTermDocs(this, this.subReaders, this.starts);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs(term);
        }
        return super.termDocs(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termPositions();
        }
        return new MultiTermPositions(this, this.subReaders, this.starts);
    }

    @Override
    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.readOnly) {
            ReadOnlySegmentReader.noWrite();
        }
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock lock = this.directory.makeLock("write.lock");
                if (!lock.obtain(IndexWriterConfig.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + lock);
                }
                this.writeLock = lock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.maxIndexVersion) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doCommit(Map<String, String> map) throws IOException {
        if (this.hasChanges) {
            this.segmentInfos.setUserData(map);
            IndexFileDeleter indexFileDeleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
            this.segmentInfos.updateGeneration(indexFileDeleter.getLastSegmentInfos());
            this.segmentInfos.changed();
            this.startCommit();
            List<SegmentInfo> list = this.segmentInfos.createBackupSegmentInfos(false);
            boolean bl = false;
            try {
                for (int i = 0; i < this.subReaders.length; ++i) {
                    this.subReaders[i].commit();
                }
                this.segmentInfos.pruneDeletedSegments();
                this.directory.sync(this.segmentInfos.files(this.directory, false));
                this.segmentInfos.commit(this.directory);
                bl = true;
            }
            finally {
                if (!bl) {
                    this.rollbackCommit();
                    indexFileDeleter.refresh();
                    this.segmentInfos.rollbackSegmentInfos(list);
                }
            }
            indexFileDeleter.checkpoint(this.segmentInfos, true);
            indexFileDeleter.close();
            this.maxIndexVersion = this.segmentInfos.getVersion();
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        this.hasChanges = false;
    }

    void startCommit() {
        this.rollbackHasChanges = this.hasChanges;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    void rollbackCommit() {
        this.hasChanges = this.rollbackHasChanges;
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    @Override
    public Map<String, String> getCommitUserData() {
        this.ensureOpen();
        return this.segmentInfos.getUserData();
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException iOException = null;
        this.normsCache = null;
        for (int i = 0; i < this.subReaders.length; ++i) {
            try {
                this.subReaders[i].decRef();
                continue;
            }
            catch (IOException iOException2) {
                if (iOException != null) continue;
                iOException = iOException2;
            }
        }
        if (this.writer != null) {
            this.writer.deletePendingFiles();
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        return DirectoryReader.getFieldNames(fieldOption, this.subReaders);
    }

    static Collection<String> getFieldNames(IndexReader.FieldOption fieldOption, IndexReader[] indexReaderArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IndexReader indexReader : indexReaderArray) {
            Collection<String> collection = indexReader.getFieldNames(fieldOption);
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }

    @Override
    public Directory directory() {
        return this.directory;
    }

    @Override
    public int getTermInfosIndexDivisor() {
        this.ensureOpen();
        return this.termInfosIndexDivisor;
    }

    @Override
    public IndexCommit getIndexCommit() throws IOException {
        this.ensureOpen();
        return new ReaderCommit(this.segmentInfos, this.directory);
    }

    public static Collection<IndexCommit> listCommits(Directory directory) throws IOException {
        String[] stringArray = directory.listAll();
        ArrayList<IndexCommit> arrayList = new ArrayList<IndexCommit>();
        SegmentInfos segmentInfos = new SegmentInfos();
        segmentInfos.read(directory);
        long l = segmentInfos.getGeneration();
        arrayList.add(new ReaderCommit(segmentInfos, directory));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.startsWith("segments") || string.equals("segments.gen") || SegmentInfos.generationFromSegmentsFileName(string) >= l) continue;
            SegmentInfos segmentInfos2 = new SegmentInfos();
            try {
                segmentInfos2.read(directory, string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                segmentInfos2 = null;
            }
            if (segmentInfos2 == null) continue;
            arrayList.add(new ReaderCommit(segmentInfos2, directory));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    static class MultiTermPositions
    extends MultiTermDocs
    implements TermPositions {
        public MultiTermPositions(IndexReader indexReader, IndexReader[] indexReaderArray, int[] nArray) {
            super(indexReader, indexReaderArray, nArray);
        }

        @Override
        protected TermDocs termDocs(IndexReader indexReader) throws IOException {
            return indexReader.termPositions();
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.current).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.current).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] byArray, int n) throws IOException {
            return ((TermPositions)this.current).getPayload(byArray, n);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.current).isPayloadAvailable();
        }
    }

    static class MultiTermDocs
    implements TermDocs {
        IndexReader topReader;
        protected IndexReader[] readers;
        protected int[] starts;
        protected Term term;
        protected int base = 0;
        protected int pointer = 0;
        private TermDocs[] readerTermDocs;
        protected TermDocs current;
        private MultiTermEnum tenum;
        int matchingSegmentPos;
        SegmentMergeInfo smi;

        public MultiTermDocs(IndexReader indexReader, IndexReader[] indexReaderArray, int[] nArray) {
            this.topReader = indexReader;
            this.readers = indexReaderArray;
            this.starts = nArray;
            this.readerTermDocs = new TermDocs[indexReaderArray.length];
        }

        @Override
        public int doc() {
            return this.base + this.current.doc();
        }

        @Override
        public int freq() {
            return this.current.freq();
        }

        @Override
        public void seek(Term term) {
            this.term = term;
            this.base = 0;
            this.pointer = 0;
            this.current = null;
            this.tenum = null;
            this.smi = null;
            this.matchingSegmentPos = 0;
        }

        @Override
        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
            if (termEnum instanceof MultiTermEnum) {
                this.tenum = (MultiTermEnum)termEnum;
                if (this.topReader != this.tenum.topReader) {
                    this.tenum = null;
                }
            }
        }

        @Override
        public boolean next() throws IOException {
            while (true) {
                if (this.current != null && this.current.next()) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                    if (this.smi == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = this.smi.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        @Override
        public int read(int[] nArray, int[] nArray2) throws IOException {
            int n;
            while (true) {
                if (this.current == null) {
                    if (this.pointer < this.readers.length) {
                        if (this.tenum != null) {
                            this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                            if (this.smi == null) {
                                this.pointer = this.readers.length;
                                return 0;
                            }
                            this.pointer = this.smi.ord;
                        }
                        this.base = this.starts[this.pointer];
                        this.current = this.termDocs(this.pointer++);
                        continue;
                    }
                    return 0;
                }
                n = this.current.read(nArray, nArray2);
                if (n != 0) break;
                this.current = null;
            }
            int n2 = this.base;
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3++;
                nArray[n4] = nArray[n4] + n2;
            }
            return n;
        }

        @Override
        public boolean skipTo(int n) throws IOException {
            while (true) {
                if (this.current != null && this.current.skipTo(n - this.base)) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    SegmentMergeInfo segmentMergeInfo;
                    if ((segmentMergeInfo = this.tenum.matchingSegments[this.matchingSegmentPos++]) == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = segmentMergeInfo.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        private TermDocs termDocs(int n) throws IOException {
            TermDocs termDocs = this.readerTermDocs[n];
            if (termDocs == null) {
                termDocs = this.readerTermDocs[n] = this.termDocs(this.readers[n]);
            }
            if (this.smi != null) {
                assert (this.smi.ord == n);
                assert (this.smi.termEnum.term().equals(this.term));
                termDocs.seek(this.smi.termEnum);
            } else {
                termDocs.seek(this.term);
            }
            return termDocs;
        }

        protected TermDocs termDocs(IndexReader indexReader) throws IOException {
            return this.term == null ? indexReader.termDocs(null) : indexReader.termDocs();
        }

        @Override
        public void close() throws IOException {
            for (int i = 0; i < this.readerTermDocs.length; ++i) {
                if (this.readerTermDocs[i] == null) continue;
                this.readerTermDocs[i].close();
            }
        }
    }

    static class MultiTermEnum
    extends TermEnum {
        IndexReader topReader;
        private SegmentMergeQueue queue;
        private Term term;
        private int docFreq;
        final SegmentMergeInfo[] matchingSegments;

        public MultiTermEnum(IndexReader indexReader, IndexReader[] indexReaderArray, int[] nArray, Term term) throws IOException {
            this.topReader = indexReader;
            this.queue = new SegmentMergeQueue(indexReaderArray.length);
            this.matchingSegments = new SegmentMergeInfo[indexReaderArray.length + 1];
            for (int i = 0; i < indexReaderArray.length; ++i) {
                IndexReader indexReader2 = indexReaderArray[i];
                TermEnum termEnum = term != null ? indexReader2.terms(term) : indexReader2.terms();
                SegmentMergeInfo segmentMergeInfo = new SegmentMergeInfo(nArray[i], termEnum, indexReader2);
                segmentMergeInfo.ord = i;
                if (term == null ? segmentMergeInfo.next() : termEnum.term() != null) {
                    this.queue.add(segmentMergeInfo);
                    continue;
                }
                segmentMergeInfo.close();
            }
            if (term != null && this.queue.size() > 0) {
                this.next();
            }
        }

        @Override
        public boolean next() throws IOException {
            SegmentMergeInfo segmentMergeInfo;
            int n;
            for (n = 0; n < this.matchingSegments.length && (segmentMergeInfo = this.matchingSegments[n]) != null; ++n) {
                if (segmentMergeInfo.next()) {
                    this.queue.add(segmentMergeInfo);
                    continue;
                }
                segmentMergeInfo.close();
            }
            n = 0;
            this.matchingSegments[0] = null;
            segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            if (segmentMergeInfo == null) {
                this.term = null;
                return false;
            }
            this.term = segmentMergeInfo.term;
            this.docFreq = 0;
            while (segmentMergeInfo != null && this.term.compareTo(segmentMergeInfo.term) == 0) {
                this.matchingSegments[n++] = segmentMergeInfo;
                this.queue.pop();
                this.docFreq += segmentMergeInfo.termEnum.docFreq();
                segmentMergeInfo = (SegmentMergeInfo)this.queue.top();
            }
            this.matchingSegments[n] = null;
            return true;
        }

        @Override
        public Term term() {
            return this.term;
        }

        @Override
        public int docFreq() {
            return this.docFreq;
        }

        @Override
        public void close() throws IOException {
            this.queue.close();
        }
    }

    private static final class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection<String> files;
        Directory dir;
        long generation;
        long version;
        final Map<String, String> userData;
        private final int segmentCount;

        ReaderCommit(SegmentInfos segmentInfos, Directory directory) throws IOException {
            this.segmentsFileName = segmentInfos.getCurrentSegmentFileName();
            this.dir = directory;
            this.userData = segmentInfos.getUserData();
            this.files = Collections.unmodifiableCollection(segmentInfos.files(directory, true));
            this.version = segmentInfos.getVersion();
            this.generation = segmentInfos.getGeneration();
            this.segmentCount = segmentInfos.size();
        }

        public String toString() {
            return "DirectoryReader.ReaderCommit(" + this.segmentsFileName + ")";
        }

        @Override
        public int getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection<String> getFileNames() {
            return this.files;
        }

        @Override
        public Directory getDirectory() {
            return this.dir;
        }

        @Override
        public long getVersion() {
            return this.version;
        }

        @Override
        public long getGeneration() {
            return this.generation;
        }

        @Override
        public boolean isDeleted() {
            return false;
        }

        @Override
        public Map<String, String> getUserData() {
            return this.userData;
        }

        @Override
        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }
}

