/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.UpgradeIndexMergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Version;

public final class IndexUpgrader {
    private final Directory dir;
    private final PrintStream infoStream;
    private final IndexWriterConfig iwc;
    private final boolean deletePriorCommits;

    private static void printUsage() {
        System.err.println("Upgrades an index so all segments created with a previous Lucene version are rewritten.");
        System.err.println("Usage:");
        System.err.println("  java " + IndexUpgrader.class.getName() + " [-delete-prior-commits] [-verbose] indexDir");
        System.err.println("This tool keeps only the last commit in an index; for this");
        System.err.println("reason, if the incoming index has more than one commit, the tool");
        System.err.println("refuses to run by default. Specify -delete-prior-commits to override");
        System.err.println("this, allowing the tool to delete all but the last commit.");
        System.err.println("WARNING: This tool may reorder document IDs!");
        System.exit(1);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = null;
        boolean bl = false;
        PrintStream printStream = null;
        for (String string2 : stringArray) {
            if ("-delete-prior-commits".equals(string2)) {
                bl = true;
                continue;
            }
            if ("-verbose".equals(string2)) {
                printStream = System.out;
                continue;
            }
            if (string == null) {
                string = string2;
                continue;
            }
            IndexUpgrader.printUsage();
        }
        if (string == null) {
            IndexUpgrader.printUsage();
        }
        new IndexUpgrader((Directory)FSDirectory.open(new File(string)), Version.LUCENE_CURRENT, printStream, bl).upgrade();
    }

    public IndexUpgrader(Directory directory, Version version) {
        this(directory, new IndexWriterConfig(version, null), null, false);
    }

    public IndexUpgrader(Directory directory, Version version, PrintStream printStream, boolean bl) {
        this(directory, new IndexWriterConfig(version, null), printStream, bl);
    }

    public IndexUpgrader(Directory directory, IndexWriterConfig indexWriterConfig, PrintStream printStream, boolean bl) {
        this.dir = directory;
        this.iwc = indexWriterConfig;
        this.infoStream = printStream;
        this.deletePriorCommits = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade() throws IOException {
        Object object;
        if (!IndexReader.indexExists(this.dir)) {
            throw new IndexNotFoundException(this.dir.toString());
        }
        if (!this.deletePriorCommits && (object = IndexReader.listCommits(this.dir)).size() > 1) {
            throw new IllegalArgumentException("This tool was invoked to not delete prior commit points, but the following commits were found: " + object);
        }
        object = (IndexWriterConfig)this.iwc.clone();
        ((IndexWriterConfig)object).setMergePolicy(new UpgradeIndexMergePolicy(((IndexWriterConfig)object).getMergePolicy()));
        ((IndexWriterConfig)object).setIndexDeletionPolicy(new KeepOnlyLastCommitDeletionPolicy());
        IndexWriter indexWriter = new IndexWriter(this.dir, (IndexWriterConfig)object);
        try {
            indexWriter.setInfoStream(this.infoStream);
            indexWriter.message("Upgrading all pre-" + Constants.LUCENE_MAIN_VERSION + " segments of index directory '" + this.dir + "' to version " + Constants.LUCENE_MAIN_VERSION + "...");
            indexWriter.forceMerge(1);
            indexWriter.message("All segments upgraded to version " + Constants.LUCENE_MAIN_VERSION);
        }
        finally {
            indexWriter.close();
        }
    }
}

