/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;

final class MergeDocIDRemapper {
    int[] starts;
    int[] newStarts;
    int[][] docMaps;
    int minDocID;
    int maxDocID;
    int docShift;

    public MergeDocIDRemapper(SegmentInfos segmentInfos, int[][] nArray, int[] nArray2, MergePolicy.OneMerge oneMerge, int n) {
        int n2;
        SegmentInfo segmentInfo;
        this.docMaps = nArray;
        SegmentInfo segmentInfo2 = oneMerge.segments.get(0);
        int n3 = 0;
        while (!(segmentInfo = segmentInfos.info(n3)).equals(segmentInfo2)) {
            this.minDocID += segmentInfo.docCount;
            ++n3;
        }
        int n4 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n4 += segmentInfos.info((int)n3).docCount;
            assert (segmentInfos.info(n3).equals(oneMerge.segments.get(n2)));
            ++n3;
        }
        this.maxDocID = this.minDocID + n4;
        this.starts = new int[nArray.length];
        this.newStarts = new int[nArray.length];
        this.starts[0] = this.minDocID;
        this.newStarts[0] = this.minDocID;
        for (n3 = 1; n3 < nArray.length; ++n3) {
            n2 = oneMerge.segments.get((int)(n3 - 1)).docCount;
            this.starts[n3] = this.starts[n3 - 1] + n2;
            this.newStarts[n3] = this.newStarts[n3 - 1] + n2 - nArray2[n3 - 1];
        }
        this.docShift = n4 - n;
        assert (this.docShift == this.maxDocID - (this.newStarts[nArray.length - 1] + oneMerge.segments.get((int)(nArray.length - 1)).docCount - nArray2[nArray.length - 1]));
    }

    public int remap(int n) {
        if (n < this.minDocID) {
            return n;
        }
        if (n >= this.maxDocID) {
            return n - this.docShift;
        }
        int n2 = 0;
        int n3 = this.docMaps.length - 1;
        while (n3 >= n2) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.starts[n4];
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            if (n > n5) {
                n2 = n4 + 1;
                continue;
            }
            while (n4 + 1 < this.docMaps.length && this.starts[n4 + 1] == n5) {
                ++n4;
            }
            if (this.docMaps[n4] != null) {
                return this.newStarts[n4] + this.docMaps[n4][n - this.starts[n4]];
            }
            return this.newStarts[n4] + n - this.starts[n4];
        }
        if (this.docMaps[n3] != null) {
            return this.newStarts[n3] + this.docMaps[n3][n - this.starts[n3]];
        }
        return this.newStarts[n3] + n - this.starts[n3];
    }
}

