/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.MapBackedSet;

public class MultiReader
extends IndexReader
implements Cloneable {
    protected IndexReader[] subReaders;
    private int[] starts;
    private boolean[] decrefOnClose;
    private Map<String, byte[]> normsCache = new HashMap<String, byte[]>();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;

    public MultiReader(IndexReader ... indexReaderArray) {
        this.initialize(indexReaderArray, true);
    }

    public MultiReader(IndexReader[] indexReaderArray, boolean bl) {
        this.initialize(indexReaderArray, bl);
    }

    private void initialize(IndexReader[] indexReaderArray, boolean bl) {
        this.subReaders = (IndexReader[])indexReaderArray.clone();
        this.starts = new int[indexReaderArray.length + 1];
        this.decrefOnClose = new boolean[indexReaderArray.length];
        for (int i = 0; i < indexReaderArray.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += indexReaderArray[i].maxDoc();
            if (!bl) {
                indexReaderArray[i].incRef();
                this.decrefOnClose[i] = true;
            } else {
                this.decrefOnClose[i] = false;
            }
            if (!indexReaderArray[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[indexReaderArray.length] = this.maxDoc;
        this.readerFinishedListeners = new MapBackedSet(new ConcurrentHashMap());
    }

    @Override
    protected synchronized IndexReader doOpenIfChanged() throws CorruptIndexException, IOException {
        return this.doOpenIfChanged(false);
    }

    @Override
    public synchronized Object clone() {
        try {
            return this.doOpenIfChanged(true);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IndexReader doOpenIfChanged(boolean bl) throws CorruptIndexException, IOException {
        int n;
        this.ensureOpen();
        boolean bl2 = false;
        IndexReader[] indexReaderArray = new IndexReader[this.subReaders.length];
        boolean bl3 = false;
        try {
            for (n = 0; n < this.subReaders.length; ++n) {
                if (bl) {
                    indexReaderArray[n] = (IndexReader)this.subReaders[n].clone();
                    bl2 = true;
                    continue;
                }
                IndexReader indexReader = IndexReader.openIfChanged(this.subReaders[n]);
                if (indexReader != null) {
                    indexReaderArray[n] = indexReader;
                    bl2 = true;
                    continue;
                }
                indexReaderArray[n] = this.subReaders[n];
            }
            bl3 = true;
        }
        finally {
            if (!bl3 && bl2) {
                for (n = 0; n < indexReaderArray.length; ++n) {
                    if (indexReaderArray[n] == this.subReaders[n]) continue;
                    try {
                        indexReaderArray[n].close();
                        continue;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (bl2) {
            boolean[] blArray = new boolean[this.subReaders.length];
            for (int i = 0; i < this.subReaders.length; ++i) {
                if (indexReaderArray[i] != this.subReaders[i]) continue;
                indexReaderArray[i].incRef();
                blArray[i] = true;
            }
            MultiReader multiReader = new MultiReader(indexReaderArray);
            multiReader.decrefOnClose = blArray;
            return multiReader;
        }
        return null;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVectors(n - this.starts[n2]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String string) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].getTermFreqVector(n - this.starts[n2], string);
    }

    @Override
    public void getTermFreqVector(int n, String string, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        this.subReaders[n2].getTermFreqVector(n - this.starts[n2], string, termVectorMapper);
    }

    @Override
    public void getTermFreqVector(int n, TermVectorMapper termVectorMapper) throws IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        this.subReaders[n2].getTermFreqVector(n - this.starts[n2], termVectorMapper);
    }

    @Override
    @Deprecated
    public boolean isOptimized() {
        this.ensureOpen();
        return false;
    }

    @Override
    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].document(n - this.starts[n2], fieldSelector);
    }

    @Override
    public boolean isDeleted(int n) {
        int n2 = this.readerIndex(n);
        return this.subReaders[n2].isDeleted(n - this.starts[n2]);
    }

    @Override
    public boolean hasDeletions() {
        this.ensureOpen();
        return this.hasDeletions;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int n2 = this.readerIndex(n);
        this.subReaders[n2].deleteDocument(n - this.starts[n2]);
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    @Override
    public boolean hasNorms(String string) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized byte[] norms(String string) throws IOException {
        this.ensureOpen();
        byte[] byArray = this.normsCache.get(string);
        if (byArray != null) {
            return byArray;
        }
        if (!this.hasNorms(string)) {
            return null;
        }
        byArray = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(string, byArray, this.starts[i]);
        }
        this.normsCache.put(string, byArray);
        return byArray;
    }

    @Override
    public synchronized void norms(String string, byte[] byArray, int n) throws IOException {
        int n2;
        this.ensureOpen();
        byte[] byArray2 = this.normsCache.get(string);
        for (n2 = 0; n2 < this.subReaders.length; ++n2) {
            this.subReaders[n2].norms(string, byArray, n + this.starts[n2]);
        }
        if (byArray2 == null && !this.hasNorms(string)) {
            Arrays.fill(byArray, n, byArray.length, Similarity.getDefault().encodeNormValue(1.0f));
        } else if (byArray2 != null) {
            System.arraycopy(byArray2, 0, byArray, n, this.maxDoc());
        } else {
            for (n2 = 0; n2 < this.subReaders.length; ++n2) {
                this.subReaders[n2].norms(string, byArray, n + this.starts[n2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSetNorm(int n, String string, byte by) throws CorruptIndexException, IOException {
        Map<String, byte[]> map = this.normsCache;
        synchronized (map) {
            this.normsCache.remove(string);
        }
        int n2 = this.readerIndex(n);
        this.subReaders[n2].setNorm(n - this.starts[n2], string, by);
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms();
        }
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].terms(term);
        }
        return new DirectoryReader.MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        int n = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            n += this.subReaders[i].docFreq(term);
        }
        return n;
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs();
        }
        return new DirectoryReader.MultiTermDocs(this, this.subReaders, this.starts);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termDocs(term);
        }
        return super.termDocs(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        if (this.subReaders.length == 1) {
            return this.subReaders[0].termPositions();
        }
        return new DirectoryReader.MultiTermPositions(this, this.subReaders, this.starts);
    }

    @Override
    protected void doCommit(Map<String, String> map) throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].commit(map);
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.decrefOnClose[i]) {
                this.subReaders[i].decRef();
                continue;
            }
            this.subReaders[i].close();
        }
    }

    @Override
    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        this.ensureOpen();
        return DirectoryReader.getFieldNames(fieldOption, this.subReaders);
    }

    @Override
    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (this.subReaders[i].isCurrent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("MultiReader does not support this method.");
    }

    @Override
    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }

    @Override
    public void addReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.addReaderFinishedListener(readerFinishedListener);
        for (IndexReader indexReader : this.subReaders) {
            indexReader.addReaderFinishedListener(readerFinishedListener);
        }
    }

    @Override
    public void removeReaderFinishedListener(IndexReader.ReaderFinishedListener readerFinishedListener) {
        super.removeReaderFinishedListener(readerFinishedListener);
        for (IndexReader indexReader : this.subReaders) {
            indexReader.removeReaderFinishedListener(readerFinishedListener);
        }
    }
}

