/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerThread;
import org.apache.lucene.index.NormsWriterPerField;
import org.apache.lucene.index.NormsWriterPerThread;
import org.apache.lucene.index.SegmentNorms;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.IOUtils;

final class NormsWriter
extends InvertedDocEndConsumer {
    private final byte defaultNorm = Similarity.getDefault().encodeNormValue(1.0f);
    private FieldInfos fieldInfos;

    NormsWriter() {
    }

    @Override
    public InvertedDocEndConsumerPerThread addThread(DocInverterPerThread docInverterPerThread) {
        return new NormsWriterPerThread(docInverterPerThread, this);
    }

    @Override
    public void abort() {
    }

    void files(Collection<String> collection) {
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        this.fieldInfos = fieldInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> map, SegmentWriteState segmentWriteState) throws IOException {
        block23: {
            IndexOutput indexOutput;
            block22: {
                HashMap<FieldInfo, ArrayList<NormsWriterPerField>> hashMap = new HashMap<FieldInfo, ArrayList<NormsWriterPerField>>();
                for (Map.Entry<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> object2 : map.entrySet()) {
                    Collection<InvertedDocEndConsumerPerField> bl = object2.getValue();
                    Iterator<InvertedDocEndConsumerPerField> n = bl.iterator();
                    while (n.hasNext()) {
                        NormsWriterPerField n2 = (NormsWriterPerField)n.next();
                        if (n2.upto > 0) {
                            ArrayList<NormsWriterPerField> i = (ArrayList<NormsWriterPerField>)hashMap.get(n2.fieldInfo);
                            if (i == null) {
                                i = new ArrayList<NormsWriterPerField>();
                                hashMap.put(n2.fieldInfo, i);
                            }
                            i.add(n2);
                            continue;
                        }
                        n.remove();
                    }
                }
                String string = IndexFileNames.segmentFileName(segmentWriteState.segmentName, "nrm");
                indexOutput = segmentWriteState.directory.createOutput(string);
                boolean bl = false;
                try {
                    indexOutput.writeBytes(SegmentNorms.NORMS_HEADER, 0, SegmentNorms.NORMS_HEADER.length);
                    int n = this.fieldInfos.size();
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n3;
                        FieldInfo fieldInfo = this.fieldInfos.fieldInfo(i);
                        List list = (List)hashMap.get(fieldInfo);
                        if (list != null) {
                            int n4;
                            int n5 = list.size();
                            ++n2;
                            NormsWriterPerField[] normsWriterPerFieldArray = new NormsWriterPerField[n5];
                            int[] nArray = new int[n5];
                            for (n4 = 0; n4 < n5; ++n4) {
                                normsWriterPerFieldArray[n4] = (NormsWriterPerField)list.get(n4);
                            }
                            n4 = n5;
                            while (n4 > 0) {
                                assert (nArray[0] < normsWriterPerFieldArray[0].docIDs.length) : " uptos[0]=" + nArray[0] + " len=" + normsWriterPerFieldArray[0].docIDs.length;
                                int n6 = 0;
                                int n7 = normsWriterPerFieldArray[0].docIDs[nArray[0]];
                                for (int j = 1; j < n4; ++j) {
                                    int n8 = normsWriterPerFieldArray[j].docIDs[nArray[j]];
                                    if (n8 >= n7) continue;
                                    n7 = n8;
                                    n6 = j;
                                }
                                assert (n7 < segmentWriteState.numDocs);
                                while (n3 < n7) {
                                    indexOutput.writeByte(this.defaultNorm);
                                    ++n3;
                                }
                                indexOutput.writeByte(normsWriterPerFieldArray[n6].norms[nArray[n6]]);
                                int n9 = n6;
                                nArray[n9] = nArray[n9] + 1;
                                ++n3;
                                if (nArray[n6] != normsWriterPerFieldArray[n6].upto) continue;
                                normsWriterPerFieldArray[n6].reset();
                                if (n6 != n4 - 1) {
                                    normsWriterPerFieldArray[n6] = normsWriterPerFieldArray[n4 - 1];
                                    nArray[n6] = nArray[n4 - 1];
                                }
                                --n4;
                            }
                            while (n3 < segmentWriteState.numDocs) {
                                indexOutput.writeByte(this.defaultNorm);
                                ++n3;
                            }
                        } else if (fieldInfo.isIndexed && !fieldInfo.omitNorms) {
                            ++n2;
                            for (n3 = 0; n3 < segmentWriteState.numDocs; ++n3) {
                                indexOutput.writeByte(this.defaultNorm);
                            }
                        }
                        assert ((long)(4 + n2 * segmentWriteState.numDocs) == indexOutput.getFilePointer()) : ".nrm file size mismatch: expected=" + (4 + n2 * segmentWriteState.numDocs) + " actual=" + indexOutput.getFilePointer();
                    }
                    bl = true;
                    if (!bl) break block22;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        IOUtils.close(indexOutput);
                    } else {
                        IOUtils.closeWhileHandlingException(indexOutput);
                    }
                    throw throwable;
                }
                IOUtils.close(indexOutput);
                break block23;
            }
            IOUtils.closeWhileHandlingException(indexOutput);
        }
    }
}

