/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.SegmentTermPositionVector;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.index.TermVectorOffsetInfo;

class ParallelArrayTermVectorMapper
extends TermVectorMapper {
    private String[] terms;
    private int[] termFreqs;
    private int[][] positions;
    private TermVectorOffsetInfo[][] offsets;
    private int currentPosition;
    private boolean storingOffsets;
    private boolean storingPositions;
    private String field;

    ParallelArrayTermVectorMapper() {
    }

    @Override
    public void setExpectations(String string, int n, boolean bl, boolean bl2) {
        this.field = string;
        this.terms = new String[n];
        this.termFreqs = new int[n];
        this.storingOffsets = bl;
        this.storingPositions = bl2;
        if (bl2) {
            this.positions = new int[n][];
        }
        if (bl) {
            this.offsets = new TermVectorOffsetInfo[n][];
        }
    }

    @Override
    public void map(String string, int n, TermVectorOffsetInfo[] termVectorOffsetInfoArray, int[] nArray) {
        this.terms[this.currentPosition] = string;
        this.termFreqs[this.currentPosition] = n;
        if (this.storingOffsets) {
            this.offsets[this.currentPosition] = termVectorOffsetInfoArray;
        }
        if (this.storingPositions) {
            this.positions[this.currentPosition] = nArray;
        }
        ++this.currentPosition;
    }

    public TermFreqVector materializeVector() {
        SegmentTermVector segmentTermVector = null;
        if (this.field != null && this.terms != null) {
            segmentTermVector = this.storingPositions || this.storingOffsets ? new SegmentTermPositionVector(this.field, this.terms, this.termFreqs, this.positions, this.offsets) : new SegmentTermVector(this.field, this.terms, this.termFreqs);
        }
        return segmentTermVector;
    }
}

