/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.util.ArrayUtil;

class ParallelPostingsArray {
    static final int BYTES_PER_POSTING = 12;
    final int size;
    final int[] textStarts;
    final int[] intStarts;
    final int[] byteStarts;

    ParallelPostingsArray(int n) {
        this.size = n;
        this.textStarts = new int[n];
        this.intStarts = new int[n];
        this.byteStarts = new int[n];
    }

    int bytesPerPosting() {
        return 12;
    }

    ParallelPostingsArray newInstance(int n) {
        return new ParallelPostingsArray(n);
    }

    final ParallelPostingsArray grow() {
        int n = ArrayUtil.oversize(this.size + 1, this.bytesPerPosting());
        ParallelPostingsArray parallelPostingsArray = this.newInstance(n);
        this.copyTo(parallelPostingsArray, this.size);
        return parallelPostingsArray;
    }

    void copyTo(ParallelPostingsArray parallelPostingsArray, int n) {
        System.arraycopy(this.textStarts, 0, parallelPostingsArray.textStarts, 0, n);
        System.arraycopy(this.intStarts, 0, parallelPostingsArray.intStarts, 0, n);
        System.arraycopy(this.byteStarts, 0, parallelPostingsArray.byteStarts, 0, n);
    }
}

