/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

public class PersistentSnapshotDeletionPolicy
extends SnapshotDeletionPolicy {
    private static final String SNAPSHOTS_ID = "$SNAPSHOTS_DOC$";
    private final IndexWriter writer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readSnapshotsInfo(Directory directory) throws IOException {
        IndexReader indexReader = IndexReader.open(directory, true);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            int n = indexReader.numDocs();
            if (n == 1) {
                Document document = indexReader.document(indexReader.maxDoc() - 1);
                Field field = document.getField(SNAPSHOTS_ID);
                if (field == null) {
                    throw new IllegalStateException("directory is not a valid snapshots store!");
                }
                document.removeField(SNAPSHOTS_ID);
                for (Fieldable fieldable : document.getFields()) {
                    hashMap.put(fieldable.name(), fieldable.stringValue());
                }
            } else if (n != 0) {
                throw new IllegalStateException("should be at most 1 document in the snapshots directory: " + n);
            }
        }
        finally {
            indexReader.close();
        }
        return hashMap;
    }

    public PersistentSnapshotDeletionPolicy(IndexDeletionPolicy indexDeletionPolicy, Directory directory, IndexWriterConfig.OpenMode openMode, Version version) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(indexDeletionPolicy, null);
        this.writer = new IndexWriter(directory, new IndexWriterConfig(version, null).setOpenMode(openMode));
        if (openMode != IndexWriterConfig.OpenMode.APPEND) {
            this.writer.commit();
        }
        try {
            for (Map.Entry<String, String> entry : PersistentSnapshotDeletionPolicy.readSnapshotsInfo(directory).entrySet()) {
                this.registerSnapshotInfo(entry.getKey(), entry.getValue(), null);
            }
        }
        catch (RuntimeException runtimeException) {
            this.writer.close();
            throw runtimeException;
        }
        catch (IOException iOException) {
            this.writer.close();
            throw iOException;
        }
    }

    @Override
    public synchronized void onInit(List<? extends IndexCommit> list) throws IOException {
        super.onInit(list);
        this.persistSnapshotInfos(null, null);
    }

    @Override
    public synchronized IndexCommit snapshot(String string) throws IOException {
        this.checkSnapshotted(string);
        if (SNAPSHOTS_ID.equals(string)) {
            throw new IllegalArgumentException(string + " is reserved and cannot be used as a snapshot id");
        }
        this.persistSnapshotInfos(string, this.lastCommit.getSegmentsFileName());
        return super.snapshot(string);
    }

    @Override
    public synchronized void release(String string) throws IOException {
        super.release(string);
        this.persistSnapshotInfos(null, null);
    }

    public void close() throws CorruptIndexException, IOException {
        this.writer.close();
    }

    private void persistSnapshotInfos(String string, String string2) throws IOException {
        this.writer.deleteAll();
        Document document = new Document();
        document.add(new Field(SNAPSHOTS_ID, "", Field.Store.YES, Field.Index.NO));
        for (Map.Entry<String, String> entry : super.getSnapshots().entrySet()) {
            document.add(new Field(entry.getKey(), entry.getValue(), Field.Store.YES, Field.Index.NO));
        }
        if (string != null) {
            document.add(new Field(string, string2, Field.Store.YES, Field.Index.NO));
        }
        this.writer.addDocument(document);
        this.writer.commit();
    }
}

