/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermBuffer;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermInfo;
import org.apache.lucene.store.IndexInput;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private IndexInput input;
    FieldInfos fieldInfos;
    long size;
    long position = -1L;
    private boolean first = true;
    private TermBuffer termBuffer = new TermBuffer();
    private TermBuffer prevBuffer = new TermBuffer();
    private TermBuffer scanBuffer = new TermBuffer();
    private TermInfo termInfo = new TermInfo();
    private int format;
    private boolean isIndex = false;
    long indexPointer = 0L;
    int indexInterval;
    int skipInterval;
    int maxSkipLevels;
    private int formatM1SkipInterval;

    SegmentTermEnum(IndexInput indexInput, FieldInfos fieldInfos, boolean bl) throws CorruptIndexException, IOException {
        this.input = indexInput;
        this.fieldInfos = fieldInfos;
        this.isIndex = bl;
        this.maxSkipLevels = 1;
        int n = this.input.readInt();
        if (n >= 0) {
            this.format = 0;
            this.size = n;
            this.indexInterval = 128;
            this.skipInterval = Integer.MAX_VALUE;
        } else {
            this.format = n;
            if (this.format < -4) {
                throw new IndexFormatTooNewException(this.input, this.format, -1, -4);
            }
            this.size = this.input.readLong();
            if (this.format == -1) {
                if (!this.isIndex) {
                    this.indexInterval = this.input.readInt();
                    this.formatM1SkipInterval = this.input.readInt();
                }
                this.skipInterval = Integer.MAX_VALUE;
            } else {
                this.indexInterval = this.input.readInt();
                this.skipInterval = this.input.readInt();
                if (this.format <= -3) {
                    this.maxSkipLevels = this.input.readInt();
                }
            }
            assert (this.indexInterval > 0) : "indexInterval=" + this.indexInterval + " is negative; must be > 0";
            assert (this.skipInterval > 0) : "skipInterval=" + this.skipInterval + " is negative; must be > 0";
        }
        if (this.format > -4) {
            this.termBuffer.setPreUTF8Strings();
            this.scanBuffer.setPreUTF8Strings();
            this.prevBuffer.setPreUTF8Strings();
        }
    }

    protected Object clone() {
        SegmentTermEnum segmentTermEnum = null;
        try {
            segmentTermEnum = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        segmentTermEnum.input = (IndexInput)this.input.clone();
        segmentTermEnum.termInfo = new TermInfo(this.termInfo);
        segmentTermEnum.termBuffer = (TermBuffer)this.termBuffer.clone();
        segmentTermEnum.prevBuffer = (TermBuffer)this.prevBuffer.clone();
        segmentTermEnum.scanBuffer = new TermBuffer();
        return segmentTermEnum;
    }

    final void seek(long l, long l2, Term term, TermInfo termInfo) throws IOException {
        this.input.seek(l);
        this.position = l2;
        this.termBuffer.set(term);
        this.prevBuffer.reset();
        this.termInfo.set(termInfo);
        this.first = l2 == -1L;
    }

    @Override
    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1L) {
            this.prevBuffer.set(this.termBuffer);
            this.termBuffer.reset();
            return false;
        }
        this.prevBuffer.set(this.termBuffer);
        this.termBuffer.read(this.input, this.fieldInfos);
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.format == -1) {
            if (!this.isIndex && this.termInfo.docFreq > this.formatM1SkipInterval) {
                this.termInfo.skipOffset = this.input.readVInt();
            }
        } else if (this.termInfo.docFreq >= this.skipInterval) {
            this.termInfo.skipOffset = this.input.readVInt();
        }
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    final int scanTo(Term term) throws IOException {
        this.scanBuffer.set(term);
        int n = 0;
        if (this.first) {
            this.next();
            this.first = false;
            ++n;
        }
        while (this.scanBuffer.compareTo(this.termBuffer) > 0 && this.next()) {
            ++n;
        }
        return n;
    }

    @Override
    public final Term term() {
        return this.termBuffer.toTerm();
    }

    final Term prev() {
        return this.prevBuffer.toTerm();
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo termInfo) {
        termInfo.set(this.termInfo);
    }

    @Override
    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    @Override
    public final void close() throws IOException {
        this.input.close();
    }
}

