/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.store.Directory;

public class SnapshotDeletionPolicy
implements IndexDeletionPolicy {
    private Map<String, SnapshotInfo> idToSnapshot = new HashMap<String, SnapshotInfo>();
    private Map<String, Set<String>> segmentsFileToIDs = new HashMap<String, Set<String>>();
    private IndexDeletionPolicy primary;
    protected IndexCommit lastCommit;

    public SnapshotDeletionPolicy(IndexDeletionPolicy indexDeletionPolicy) {
        this.primary = indexDeletionPolicy;
    }

    public SnapshotDeletionPolicy(IndexDeletionPolicy indexDeletionPolicy, Map<String, String> map) {
        this(indexDeletionPolicy);
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.registerSnapshotInfo(entry.getKey(), entry.getValue(), null);
            }
        }
    }

    protected void checkSnapshotted(String string) {
        if (this.isSnapshotted(string)) {
            throw new IllegalStateException("Snapshot ID " + string + " is already used - must be unique");
        }
    }

    protected void registerSnapshotInfo(String string, String string2, IndexCommit indexCommit) {
        this.idToSnapshot.put(string, new SnapshotInfo(string, string2, indexCommit));
        Set<String> set = this.segmentsFileToIDs.get(string2);
        if (set == null) {
            set = new HashSet<String>();
            this.segmentsFileToIDs.put(string2, set);
        }
        set.add(string);
    }

    protected List<IndexCommit> wrapCommits(List<? extends IndexCommit> list) {
        ArrayList<IndexCommit> arrayList = new ArrayList<IndexCommit>(list.size());
        for (IndexCommit indexCommit : list) {
            arrayList.add(new SnapshotCommitPoint(indexCommit));
        }
        return arrayList;
    }

    public synchronized IndexCommit getSnapshot(String string) {
        SnapshotInfo snapshotInfo = this.idToSnapshot.get(string);
        if (snapshotInfo == null) {
            throw new IllegalStateException("No snapshot exists by ID: " + string);
        }
        return snapshotInfo.commit;
    }

    public synchronized Map<String, String> getSnapshots() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, SnapshotInfo> entry : this.idToSnapshot.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().segmentsFileName);
        }
        return hashMap;
    }

    public boolean isSnapshotted(String string) {
        return this.idToSnapshot.containsKey(string);
    }

    @Override
    public synchronized void onCommit(List<? extends IndexCommit> list) throws IOException {
        this.primary.onCommit(this.wrapCommits(list));
        this.lastCommit = list.get(list.size() - 1);
    }

    @Override
    public synchronized void onInit(List<? extends IndexCommit> list) throws IOException {
        this.primary.onInit(this.wrapCommits(list));
        this.lastCommit = list.get(list.size() - 1);
        for (IndexCommit object2 : list) {
            Set<String> set = this.segmentsFileToIDs.get(object2.getSegmentsFileName());
            if (set == null) continue;
            for (String string : set) {
                this.idToSnapshot.get((Object)string).commit = object2;
            }
        }
        Object object = null;
        for (Map.Entry<String, SnapshotInfo> entry : this.idToSnapshot.entrySet()) {
            if (entry.getValue().commit != null) continue;
            if (object == null) {
                object = new ArrayList();
            }
            ((ArrayList)object).add((String)entry.getKey());
        }
        if (object != null) {
            Iterator iterator = ((ArrayList)object).iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SnapshotInfo snapshotInfo = this.idToSnapshot.remove(string);
                this.segmentsFileToIDs.remove(snapshotInfo.segmentsFileName);
            }
        }
    }

    public synchronized void release(String string) throws IOException {
        SnapshotInfo snapshotInfo = this.idToSnapshot.remove(string);
        if (snapshotInfo == null) {
            throw new IllegalStateException("Snapshot doesn't exist: " + string);
        }
        Set<String> set = this.segmentsFileToIDs.get(snapshotInfo.segmentsFileName);
        if (set != null) {
            set.remove(string);
            if (set.size() == 0) {
                this.segmentsFileToIDs.remove(snapshotInfo.segmentsFileName);
            }
        }
    }

    public synchronized IndexCommit snapshot(String string) throws IOException {
        if (this.lastCommit == null) {
            throw new IllegalStateException("No index commit to snapshot");
        }
        this.checkSnapshotted(string);
        this.registerSnapshotInfo(string, this.lastCommit.getSegmentsFileName(), this.lastCommit);
        return this.lastCommit;
    }

    protected class SnapshotCommitPoint
    extends IndexCommit {
        protected IndexCommit cp;

        protected SnapshotCommitPoint(IndexCommit indexCommit) {
            this.cp = indexCommit;
        }

        public String toString() {
            return "SnapshotDeletionPolicy.SnapshotCommitPoint(" + this.cp + ")";
        }

        protected boolean shouldDelete(String string) {
            return !SnapshotDeletionPolicy.this.segmentsFileToIDs.containsKey(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete() {
            SnapshotDeletionPolicy snapshotDeletionPolicy = SnapshotDeletionPolicy.this;
            synchronized (snapshotDeletionPolicy) {
                if (this.shouldDelete(this.getSegmentsFileName())) {
                    this.cp.delete();
                }
            }
        }

        @Override
        public Directory getDirectory() {
            return this.cp.getDirectory();
        }

        @Override
        public Collection<String> getFileNames() throws IOException {
            return this.cp.getFileNames();
        }

        @Override
        public long getGeneration() {
            return this.cp.getGeneration();
        }

        @Override
        public String getSegmentsFileName() {
            return this.cp.getSegmentsFileName();
        }

        @Override
        public Map<String, String> getUserData() throws IOException {
            return this.cp.getUserData();
        }

        @Override
        public long getVersion() {
            return this.cp.getVersion();
        }

        @Override
        public boolean isDeleted() {
            return this.cp.isDeleted();
        }

        @Override
        public int getSegmentCount() {
            return this.cp.getSegmentCount();
        }
    }

    private static class SnapshotInfo {
        String id;
        String segmentsFileName;
        IndexCommit commit;

        public SnapshotInfo(String string, String string2, IndexCommit indexCommit) {
            this.id = string;
            this.segmentsFileName = string2;
            this.commit = indexCommit;
        }

        public String toString() {
            return this.id + " : " + this.segmentsFileName;
        }
    }
}

