/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanScorer2;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query
implements Iterable<BooleanClause> {
    private static int maxClauseCount = 1024;
    private ArrayList<BooleanClause> clauses = new ArrayList();
    private final boolean disableCoord;
    protected int minNrShouldMatch = 0;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        maxClauseCount = n;
    }

    public BooleanQuery() {
        this.disableCoord = false;
    }

    public BooleanQuery(boolean bl) {
        this.disableCoord = bl;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public void setMinimumNumberShouldMatch(int n) {
        this.minNrShouldMatch = n;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minNrShouldMatch;
    }

    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause booleanClause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(booleanClause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    public List<BooleanClause> clauses() {
        return this.clauses;
    }

    @Override
    public final Iterator<BooleanClause> iterator() {
        return this.clauses().iterator();
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new BooleanWeight(searcher, this.disableCoord);
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        Serializable serializable;
        if (this.minNrShouldMatch == 0 && this.clauses.size() == 1 && !(serializable = this.clauses.get(0)).isProhibited()) {
            Query query = serializable.getQuery().rewrite(indexReader);
            if (this.getBoost() != 1.0f) {
                if (query == serializable.getQuery()) {
                    query = (Query)query.clone();
                }
                query.setBoost(this.getBoost() * query.getBoost());
            }
            return query;
        }
        serializable = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause booleanClause = this.clauses.get(i);
            Query query = booleanClause.getQuery().rewrite(indexReader);
            if (query == booleanClause.getQuery()) continue;
            if (serializable == null) {
                serializable = (BooleanQuery)this.clone();
            }
            ((BooleanQuery)serializable).clauses.set(i, new BooleanClause(query, booleanClause.getOccur()));
        }
        if (serializable != null) {
            return serializable;
        }
        return this;
    }

    @Override
    public void extractTerms(Set<Term> set) {
        for (BooleanClause booleanClause : this.clauses) {
            booleanClause.getQuery().extractTerms(set);
        }
    }

    @Override
    public Object clone() {
        BooleanQuery booleanQuery = (BooleanQuery)super.clone();
        booleanQuery.clauses = (ArrayList)this.clauses.clone();
        return booleanQuery;
    }

    @Override
    public String toString(String string) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (bl) {
            stringBuilder.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause booleanClause = this.clauses.get(i);
            if (booleanClause.isProhibited()) {
                stringBuilder.append("-");
            } else if (booleanClause.isRequired()) {
                stringBuilder.append("+");
            }
            Query query = booleanClause.getQuery();
            if (query != null) {
                if (query instanceof BooleanQuery) {
                    stringBuilder.append("(");
                    stringBuilder.append(query.toString(string));
                    stringBuilder.append(")");
                } else {
                    stringBuilder.append(query.toString(string));
                }
            } else {
                stringBuilder.append("null");
            }
            if (i == this.clauses.size() - 1) continue;
            stringBuilder.append(" ");
        }
        if (bl) {
            stringBuilder.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            stringBuilder.append('~');
            stringBuilder.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery booleanQuery = (BooleanQuery)object;
        return this.getBoost() == booleanQuery.getBoost() && this.clauses.equals(booleanQuery.clauses) && this.getMinimumNumberShouldMatch() == booleanQuery.getMinimumNumberShouldMatch() && this.disableCoord == booleanQuery.disableCoord;
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode() + this.getMinimumNumberShouldMatch() + (this.disableCoord ? 17 : 0);
    }

    protected class BooleanWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList<Weight> weights;
        protected int maxCoord;
        private final boolean disableCoord;

        public BooleanWeight(Searcher searcher, boolean bl) throws IOException {
            this.similarity = BooleanQuery.this.getSimilarity(searcher);
            this.disableCoord = bl;
            this.weights = new ArrayList(BooleanQuery.this.clauses.size());
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause booleanClause = (BooleanClause)BooleanQuery.this.clauses.get(i);
                this.weights.add(booleanClause.getQuery().createWeight(searcher));
                if (booleanClause.isProhibited()) continue;
                ++this.maxCoord;
            }
        }

        @Override
        public Query getQuery() {
            return BooleanQuery.this;
        }

        @Override
        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float f = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                float f2 = this.weights.get(i).sumOfSquaredWeights();
                if (((BooleanClause)BooleanQuery.this.clauses.get(i)).isProhibited()) continue;
                f += f2;
            }
            return f *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        @Override
        public void normalize(float f) {
            f *= BooleanQuery.this.getBoost();
            for (Weight weight : this.weights) {
                weight.normalize(f);
            }
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            float f;
            int n2 = BooleanQuery.this.getMinimumNumberShouldMatch();
            ComplexExplanation complexExplanation = new ComplexExplanation();
            complexExplanation.setDescription("sum of:");
            int n3 = 0;
            float f2 = 0.0f;
            boolean bl = false;
            int n4 = 0;
            Iterator iterator = BooleanQuery.this.clauses.iterator();
            for (Weight serializable2 : this.weights) {
                Explanation explanation;
                Explanation explanation2;
                BooleanClause booleanClause = (BooleanClause)iterator.next();
                if (serializable2.scorer(indexReader, true, true) == null) {
                    if (!booleanClause.isRequired()) continue;
                    bl = true;
                    explanation2 = new Explanation(0.0f, "no match on required clause (" + booleanClause.getQuery().toString() + ")");
                    complexExplanation.addDetail(explanation2);
                    continue;
                }
                explanation2 = serializable2.explain(indexReader, n);
                if (explanation2.isMatch()) {
                    if (!booleanClause.isProhibited()) {
                        complexExplanation.addDetail(explanation2);
                        f2 += explanation2.getValue();
                        ++n3;
                    } else {
                        explanation = new Explanation(0.0f, "match on prohibited clause (" + booleanClause.getQuery().toString() + ")");
                        explanation.addDetail(explanation2);
                        complexExplanation.addDetail(explanation);
                        bl = true;
                    }
                    if (booleanClause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                    ++n4;
                    continue;
                }
                if (!booleanClause.isRequired()) continue;
                explanation = new Explanation(0.0f, "no match on required clause (" + booleanClause.getQuery().toString() + ")");
                explanation.addDetail(explanation2);
                complexExplanation.addDetail(explanation);
                bl = true;
            }
            if (bl) {
                complexExplanation.setMatch(Boolean.FALSE);
                complexExplanation.setValue(0.0f);
                complexExplanation.setDescription("Failure to meet condition(s) of required/prohibited clause(s)");
                return complexExplanation;
            }
            if (n4 < n2) {
                complexExplanation.setMatch(Boolean.FALSE);
                complexExplanation.setValue(0.0f);
                complexExplanation.setDescription("Failure to match minimum number of optional clauses: " + n2);
                return complexExplanation;
            }
            complexExplanation.setMatch(0 < n3 ? Boolean.TRUE : Boolean.FALSE);
            complexExplanation.setValue(f2);
            float f3 = f = this.disableCoord ? 1.0f : this.similarity.coord(n3, this.maxCoord);
            if (f == 1.0f) {
                return complexExplanation;
            }
            ComplexExplanation complexExplanation2 = new ComplexExplanation(complexExplanation.isMatch(), f2 * f, "product of:");
            complexExplanation2.addDetail(complexExplanation);
            complexExplanation2.addDetail(new Explanation(f, "coord(" + n3 + "/" + this.maxCoord + ")"));
            return complexExplanation2;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            ArrayList<Scorer> arrayList = new ArrayList<Scorer>();
            ArrayList<Scorer> arrayList2 = new ArrayList<Scorer>();
            ArrayList<Scorer> arrayList3 = new ArrayList<Scorer>();
            Iterator iterator = BooleanQuery.this.clauses.iterator();
            for (Weight weight : this.weights) {
                BooleanClause booleanClause = (BooleanClause)iterator.next();
                Scorer scorer = weight.scorer(indexReader, true, false);
                if (scorer == null) {
                    if (!booleanClause.isRequired()) continue;
                    return null;
                }
                if (booleanClause.isRequired()) {
                    arrayList.add(scorer);
                    continue;
                }
                if (booleanClause.isProhibited()) {
                    arrayList2.add(scorer);
                    continue;
                }
                arrayList3.add(scorer);
            }
            if (!bl && bl2 && arrayList.size() == 0) {
                return new BooleanScorer(this, this.disableCoord, this.similarity, BooleanQuery.this.minNrShouldMatch, arrayList3, arrayList2, this.maxCoord);
            }
            if (arrayList.size() == 0 && arrayList3.size() == 0) {
                return null;
            }
            if (arrayList3.size() < BooleanQuery.this.minNrShouldMatch) {
                return null;
            }
            return new BooleanScorer2(this, this.disableCoord, this.similarity, BooleanQuery.this.minNrShouldMatch, arrayList, arrayList2, arrayList3, this.maxCoord);
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            for (BooleanClause booleanClause : BooleanQuery.this.clauses) {
                if (!booleanClause.isRequired()) continue;
                return false;
            }
            return true;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public TooManyClauses() {
            super("maxClauseCount is set to " + maxClauseCount);
        }
    }
}

