/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

final class ExactPhraseScorer
extends Scorer {
    private final byte[] norms;
    private final float value;
    private static final int SCORE_CACHE_SIZE = 32;
    private final float[] scoreCache = new float[32];
    private final int endMinus1;
    private static final int CHUNK = 4096;
    private int gen;
    private final int[] counts = new int[4096];
    private final int[] gens = new int[4096];
    boolean noDocs;
    private final ChunkState[] chunkStates;
    private int docID = -1;
    private int freq;

    ExactPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postingsAndFreqArray, Similarity similarity, byte[] byArray) throws IOException {
        super(similarity, weight);
        int n;
        this.norms = byArray;
        this.value = weight.getValue();
        this.chunkStates = new ChunkState[postingsAndFreqArray.length];
        this.endMinus1 = postingsAndFreqArray.length - 1;
        for (n = 0; n < postingsAndFreqArray.length; ++n) {
            boolean bl = postingsAndFreqArray[n].docFreq > 5 * postingsAndFreqArray[0].docFreq;
            this.chunkStates[n] = new ChunkState(postingsAndFreqArray[n].postings, -postingsAndFreqArray[n].position, bl);
            if (n <= 0 || postingsAndFreqArray[n].postings.next()) continue;
            this.noDocs = true;
            return;
        }
        for (n = 0; n < 32; ++n) {
            this.scoreCache[n] = this.getSimilarity().tf((float)n) * this.value;
        }
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int n;
            if (!this.chunkStates[0].posEnum.next()) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            int n2 = this.chunkStates[0].posEnum.doc();
            for (n = 1; n < this.chunkStates.length; ++n) {
                ChunkState chunkState = this.chunkStates[n];
                int n3 = chunkState.posEnum.doc();
                if (chunkState.useAdvance) {
                    if (n3 < n2) {
                        if (!chunkState.posEnum.skipTo(n2)) {
                            this.docID = Integer.MAX_VALUE;
                            return this.docID;
                        }
                        n3 = chunkState.posEnum.doc();
                    }
                } else {
                    int n4 = 0;
                    while (n3 < n2) {
                        if (++n4 == 50) {
                            if (!chunkState.posEnum.skipTo(n2)) {
                                this.docID = Integer.MAX_VALUE;
                                return this.docID;
                            }
                            n3 = chunkState.posEnum.doc();
                            break;
                        }
                        if (chunkState.posEnum.next()) {
                            n3 = chunkState.posEnum.doc();
                            continue;
                        }
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                }
                if (n3 > n2) break;
            }
            if (n != this.chunkStates.length) continue;
            this.docID = n2;
            this.freq = this.phraseFreq();
            if (this.freq != 0) break;
        }
        return this.docID;
    }

    @Override
    public int advance(int n) throws IOException {
        if (!this.chunkStates[0].posEnum.skipTo(n)) {
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }
        int n2 = this.chunkStates[0].posEnum.doc();
        while (true) {
            int n3;
            for (n3 = 1; n3 < this.chunkStates.length; ++n3) {
                int n4 = this.chunkStates[n3].posEnum.doc();
                if (n4 < n2) {
                    if (!this.chunkStates[n3].posEnum.skipTo(n2)) {
                        this.docID = Integer.MAX_VALUE;
                        return this.docID;
                    }
                    n4 = this.chunkStates[n3].posEnum.doc();
                }
                if (n4 > n2) break;
            }
            if (n3 == this.chunkStates.length) {
                this.docID = n2;
                this.freq = this.phraseFreq();
                if (this.freq != 0) {
                    return this.docID;
                }
            }
            if (!this.chunkStates[0].posEnum.next()) {
                this.docID = Integer.MAX_VALUE;
                return this.docID;
            }
            n2 = this.chunkStates[0].posEnum.doc();
        }
    }

    public String toString() {
        return "ExactPhraseScorer(" + this.weight + ")";
    }

    @Override
    public float freq() {
        return this.freq;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public float score() throws IOException {
        float f = this.freq < 32 ? this.scoreCache[this.freq] : this.getSimilarity().tf((float)this.freq) * this.value;
        return this.norms == null ? f : f * this.getSimilarity().decodeNormValue(this.norms[this.docID]);
    }

    private int phraseFreq() throws IOException {
        int n;
        this.freq = 0;
        for (n = 0; n < this.chunkStates.length; ++n) {
            ChunkState chunkState = this.chunkStates[n];
            chunkState.posLimit = chunkState.posEnum.freq();
            chunkState.pos = chunkState.offset + chunkState.posEnum.nextPosition();
            chunkState.posUpto = 1;
            chunkState.lastPos = -1;
        }
        n = 0;
        int n2 = 4096;
        boolean bl = false;
        while (!bl) {
            int n3;
            ++this.gen;
            if (this.gen == 0) {
                Arrays.fill(this.gens, 0);
                ++this.gen;
            }
            ChunkState chunkState = this.chunkStates[0];
            while (chunkState.pos < n2) {
                if (chunkState.pos > chunkState.lastPos) {
                    chunkState.lastPos = chunkState.pos;
                    n3 = chunkState.pos - n;
                    this.counts[n3] = 1;
                    assert (this.gens[n3] != this.gen);
                    this.gens[n3] = this.gen;
                }
                if (chunkState.posUpto == chunkState.posLimit) {
                    bl = true;
                    break;
                }
                ++chunkState.posUpto;
                chunkState.pos = chunkState.offset + chunkState.posEnum.nextPosition();
            }
            boolean bl2 = true;
            for (n3 = 1; n3 < this.endMinus1; ++n3) {
                ChunkState chunkState2 = this.chunkStates[n3];
                bl2 = false;
                while (chunkState2.pos < n2) {
                    if (chunkState2.pos > chunkState2.lastPos) {
                        chunkState2.lastPos = chunkState2.pos;
                        int n4 = chunkState2.pos - n;
                        if (n4 >= 0 && this.gens[n4] == this.gen && this.counts[n4] == n3) {
                            int n5 = n4;
                            this.counts[n5] = this.counts[n5] + 1;
                            bl2 = true;
                        }
                    }
                    if (chunkState2.posUpto == chunkState2.posLimit) {
                        bl = true;
                        break;
                    }
                    ++chunkState2.posUpto;
                    chunkState2.pos = chunkState2.offset + chunkState2.posEnum.nextPosition();
                }
                if (!bl2) break;
            }
            if (!bl2) {
                n += 4096;
                n2 += 4096;
                continue;
            }
            ChunkState chunkState3 = this.chunkStates[this.endMinus1];
            while (chunkState3.pos < n2) {
                if (chunkState3.pos > chunkState3.lastPos) {
                    chunkState3.lastPos = chunkState3.pos;
                    int n6 = chunkState3.pos - n;
                    if (n6 >= 0 && this.gens[n6] == this.gen && this.counts[n6] == this.endMinus1) {
                        ++this.freq;
                    }
                }
                if (chunkState3.posUpto == chunkState3.posLimit) {
                    bl = true;
                    break;
                }
                ++chunkState3.posUpto;
                chunkState3.pos = chunkState3.offset + chunkState3.posEnum.nextPosition();
            }
            n += 4096;
            n2 += 4096;
        }
        return this.freq;
    }

    private static final class ChunkState {
        final TermPositions posEnum;
        final int offset;
        final boolean useAdvance;
        int posUpto;
        int posLimit;
        int pos;
        int lastPos;

        public ChunkState(TermPositions termPositions, int n, boolean bl) {
            this.posEnum = termPositions;
            this.offset = n;
            this.useAdvance = bl;
        }
    }
}

