/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.PriorityQueue;

public abstract class FieldValueHitQueue<T extends Entry>
extends PriorityQueue<T> {
    protected final SortField[] fields;
    protected final FieldComparator[] comparators;
    protected final int[] reverseMul;

    private FieldValueHitQueue(SortField[] sortFieldArray) {
        this.fields = sortFieldArray;
        int n = sortFieldArray.length;
        this.comparators = new FieldComparator[n];
        this.reverseMul = new int[n];
    }

    public static <T extends Entry> FieldValueHitQueue<T> create(SortField[] sortFieldArray, int n) throws IOException {
        if (sortFieldArray.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (sortFieldArray.length == 1) {
            return new OneComparatorFieldValueHitQueue(sortFieldArray, n);
        }
        return new MultiComparatorsFieldValueHitQueue(sortFieldArray, n);
    }

    public FieldComparator[] getComparators() {
        return this.comparators;
    }

    public int[] getReverseMul() {
        return this.reverseMul;
    }

    @Override
    protected abstract boolean lessThan(Entry var1, Entry var2);

    FieldDoc fillFields(Entry entry) {
        int n = this.comparators.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.comparators[i].value(entry.slot);
        }
        return new FieldDoc(entry.doc, entry.score, objectArray);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private static final class MultiComparatorsFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        public MultiComparatorsFieldValueHitQueue(SortField[] sortFieldArray, int n) throws IOException {
            super(sortFieldArray);
            int n2 = this.comparators.length;
            for (int i = 0; i < n2; ++i) {
                SortField sortField = sortFieldArray[i];
                this.reverseMul[i] = sortField.reverse ? -1 : 1;
                this.comparators[i] = sortField.getComparator(n, i);
            }
            this.initialize(n);
        }

        @Override
        protected boolean lessThan(Entry entry, Entry entry2) {
            assert (entry != entry2);
            assert (entry.slot != entry2.slot);
            int n = this.comparators.length;
            for (int i = 0; i < n; ++i) {
                int n2 = this.reverseMul[i] * this.comparators[i].compare(entry.slot, entry2.slot);
                if (n2 == 0) continue;
                return n2 > 0;
            }
            return entry.doc > entry2.doc;
        }
    }

    private static final class OneComparatorFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        private final FieldComparator comparator;
        private final int oneReverseMul;

        public OneComparatorFieldValueHitQueue(SortField[] sortFieldArray, int n) throws IOException {
            super(sortFieldArray);
            SortField sortField = sortFieldArray[0];
            this.comparator = sortField.getComparator(n, 0);
            this.oneReverseMul = sortField.reverse ? -1 : 1;
            this.comparators[0] = this.comparator;
            this.reverseMul[0] = this.oneReverseMul;
            this.initialize(n);
        }

        @Override
        protected boolean lessThan(Entry entry, Entry entry2) {
            assert (entry != entry2);
            assert (entry.slot != entry2.slot);
            int n = this.oneReverseMul * this.comparator.compare(entry.slot, entry2.slot);
            if (n != 0) {
                return n > 0;
            }
            return entry.doc > entry2.doc;
        }
    }

    public static class Entry
    extends ScoreDoc {
        public int slot;

        public Entry(int n, int n2, float f) {
            super(n2, f);
            this.slot = n;
        }

        @Override
        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }
}

