/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.ThreadInterruptedException;

@Deprecated
public class FilterManager {
    protected static FilterManager manager;
    protected static final int DEFAULT_CACHE_CLEAN_SIZE = 100;
    protected static final long DEFAULT_CACHE_SLEEP_TIME = 600000L;
    protected Map<Integer, FilterItem> cache = new HashMap<Integer, FilterItem>();
    protected int cacheCleanSize = 100;
    protected long cleanSleepTime = 600000L;
    protected FilterCleaner filterCleaner = new FilterCleaner();

    public static synchronized FilterManager getInstance() {
        if (manager == null) {
            manager = new FilterManager();
        }
        return manager;
    }

    protected FilterManager() {
        Thread thread = new Thread(this.filterCleaner);
        thread.setDaemon(true);
        thread.start();
    }

    public void setCacheSize(int n) {
        this.cacheCleanSize = n;
    }

    public void setCleanThreadSleepTime(long l) {
        this.cleanSleepTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter getFilter(Filter filter) {
        Map<Integer, FilterItem> map = this.cache;
        synchronized (map) {
            FilterItem filterItem = null;
            filterItem = this.cache.get(filter.hashCode());
            if (filterItem != null) {
                filterItem.timestamp = new Date().getTime();
                return filterItem.filter;
            }
            this.cache.put(filter.hashCode(), new FilterItem(filter));
            return filter;
        }
    }

    protected class FilterCleaner
    implements Runnable {
        private boolean running = true;
        private TreeSet<Map.Entry<Integer, FilterItem>> sortedFilterItems;

        public FilterCleaner() {
            this.sortedFilterItems = new TreeSet<Map.Entry<Integer, FilterItem>>(new Comparator<Map.Entry<Integer, FilterItem>>(){

                @Override
                public int compare(Map.Entry<Integer, FilterItem> entry, Map.Entry<Integer, FilterItem> entry2) {
                    FilterItem filterItem = entry.getValue();
                    FilterItem filterItem2 = entry2.getValue();
                    if (filterItem.timestamp == filterItem2.timestamp) {
                        return 0;
                    }
                    if (filterItem.timestamp < filterItem2.timestamp) {
                        return -1;
                    }
                    return 1;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                if (FilterManager.this.cache.size() > FilterManager.this.cacheCleanSize) {
                    this.sortedFilterItems.clear();
                    Map<Integer, FilterItem> map = FilterManager.this.cache;
                    synchronized (map) {
                        this.sortedFilterItems.addAll(FilterManager.this.cache.entrySet());
                        Iterator<Map.Entry<Integer, FilterItem>> iterator = this.sortedFilterItems.iterator();
                        int n = (int)((double)(FilterManager.this.cache.size() - FilterManager.this.cacheCleanSize) * 1.5);
                        int n2 = 0;
                        while (iterator.hasNext() && n2++ < n) {
                            Map.Entry<Integer, FilterItem> entry = iterator.next();
                            FilterManager.this.cache.remove(entry.getKey());
                        }
                    }
                    this.sortedFilterItems.clear();
                }
                try {
                    Thread.sleep(FilterManager.this.cleanSleepTime);
                }
                catch (InterruptedException interruptedException) {
                    throw new ThreadInterruptedException(interruptedException);
                }
            }
        }
    }

    protected class FilterItem {
        public Filter filter;
        public long timestamp;

        public FilterItem(Filter filter) {
            this.filter = filter;
            this.timestamp = new Date().getTime();
        }
    }
}

