/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    private int[] p;
    private int[] d;
    private float similarity;
    private boolean endEnum = false;
    private Term searchTerm = null;
    private final String field;
    private final char[] text;
    private final String prefix;
    private final float minimumSimilarity;
    private final float scale_factor;

    public FuzzyTermEnum(IndexReader indexReader, Term term) throws IOException {
        this(indexReader, term, 0.5f, 0);
    }

    public FuzzyTermEnum(IndexReader indexReader, Term term, float f) throws IOException {
        this(indexReader, term, f, 0);
    }

    public FuzzyTermEnum(IndexReader indexReader, Term term, float f, int n) throws IOException {
        if (f >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be greater than or equal to 1");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be less than 0");
        }
        if (n < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.minimumSimilarity = f;
        this.scale_factor = 1.0f / (1.0f - this.minimumSimilarity);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        int n2 = this.searchTerm.text().length();
        int n3 = n > n2 ? n2 : n;
        this.text = this.searchTerm.text().substring(n3).toCharArray();
        this.prefix = this.searchTerm.text().substring(0, n3);
        this.p = new int[this.text.length + 1];
        this.d = new int[this.text.length + 1];
        this.setEnum(indexReader.terms(new Term(this.searchTerm.field(), this.prefix)));
    }

    @Override
    protected final boolean termCompare(Term term) {
        if (this.field == term.field() && term.text().startsWith(this.prefix)) {
            String string = term.text().substring(this.prefix.length());
            this.similarity = this.similarity(string);
            return this.similarity > this.minimumSimilarity;
        }
        this.endEnum = true;
        return false;
    }

    @Override
    public final float difference() {
        return (this.similarity - this.minimumSimilarity) * this.scale_factor;
    }

    @Override
    public final boolean endEnum() {
        return this.endEnum;
    }

    private float similarity(String string) {
        int n;
        int n2 = string.length();
        int n3 = this.text.length;
        if (n3 == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)n2 / (float)this.prefix.length();
        }
        if (n2 == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)n3 / (float)this.prefix.length();
        }
        int n4 = this.calculateMaxDistance(n2);
        if (n4 < Math.abs(n2 - n3)) {
            return 0.0f;
        }
        for (n = 0; n <= n3; ++n) {
            this.p[n] = n;
        }
        for (n = 1; n <= n2; ++n) {
            int n5 = n2;
            char c = string.charAt(n - 1);
            this.d[0] = n;
            for (int i = 1; i <= n3; ++i) {
                this.d[i] = c != this.text[i - 1] ? Math.min(Math.min(this.d[i - 1], this.p[i]), this.p[i - 1]) + 1 : Math.min(Math.min(this.d[i - 1] + 1, this.p[i] + 1), this.p[i - 1]);
                n5 = Math.min(n5, this.d[i]);
            }
            if (n > n4 && n5 > n4) {
                return 0.0f;
            }
            int[] nArray = this.p;
            this.p = this.d;
            this.d = nArray;
        }
        return 1.0f - (float)this.p[n3] / (float)(this.prefix.length() + Math.min(n3, n2));
    }

    private int calculateMaxDistance(int n) {
        return (int)((1.0f - this.minimumSimilarity) * (float)(Math.min(this.text.length, n) + this.prefix.length()));
    }

    @Override
    public void close() throws IOException {
        this.d = null;
        this.p = null;
        this.searchTerm = null;
        super.close();
    }
}

