/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldDocSortedHitQueue;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.DummyConcurrentLock;
import org.apache.lucene.util.ReaderUtil;

@Deprecated
public class MultiSearcher
extends Searcher {
    private Searchable[] searchables;
    private int[] starts;
    private int maxDoc = 0;

    public MultiSearcher(Searchable ... searchableArray) throws IOException {
        this.searchables = searchableArray;
        this.starts = new int[searchableArray.length + 1];
        for (int i = 0; i < searchableArray.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += searchableArray[i].maxDoc();
        }
        this.starts[searchableArray.length] = this.maxDoc;
    }

    public Searchable[] getSearchables() {
        return this.searchables;
    }

    protected int[] getStarts() {
        return this.starts;
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            this.searchables[i].close();
        }
    }

    @Override
    public int docFreq(Term term) throws IOException {
        int n = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            n += this.searchables[i].docFreq(term);
        }
        return n;
    }

    @Override
    public Document doc(int n) throws CorruptIndexException, IOException {
        int n2 = this.subSearcher(n);
        return this.searchables[n2].doc(n - this.starts[n2]);
    }

    @Override
    public Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        int n2 = this.subSearcher(n);
        return this.searchables[n2].doc(n - this.starts[n2], fieldSelector);
    }

    public int subSearcher(int n) {
        return ReaderUtil.subIndex(n, this.starts);
    }

    public int subDoc(int n) {
        return n - this.starts[this.subSearcher(n)];
    }

    @Override
    public int maxDoc() throws IOException {
        return this.maxDoc;
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
        n = Math.min(n, this.maxDoc());
        HitQueue hitQueue = new HitQueue(n, false);
        int n2 = 0;
        for (int i = 0; i < this.searchables.length; ++i) {
            TopDocs topDocs = new MultiSearcherCallableNoSort(DummyConcurrentLock.INSTANCE, this.searchables[i], weight, filter, n, hitQueue, i, this.starts).call();
            n2 += topDocs.totalHits;
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[hitQueue.size()];
        for (int i = hitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)hitQueue.pop();
        }
        float f = n2 == 0 ? Float.NEGATIVE_INFINITY : scoreDocArray[0].score;
        return new TopDocs(n2, scoreDocArray, f);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        n = Math.min(n, this.maxDoc());
        FieldDocSortedHitQueue fieldDocSortedHitQueue = new FieldDocSortedHitQueue(n);
        int n2 = 0;
        float f = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.searchables.length; ++i) {
            TopFieldDocs topFieldDocs = new MultiSearcherCallableWithSort(DummyConcurrentLock.INSTANCE, this.searchables[i], weight, filter, n, fieldDocSortedHitQueue, sort, i, this.starts).call();
            n2 += topFieldDocs.totalHits;
            f = Math.max(f, topFieldDocs.getMaxScore());
        }
        ScoreDoc[] scoreDocArray = new ScoreDoc[fieldDocSortedHitQueue.size()];
        for (int i = fieldDocSortedHitQueue.size() - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)fieldDocSortedHitQueue.pop();
        }
        return new TopFieldDocs(n2, scoreDocArray, fieldDocSortedHitQueue.getFields(), f);
    }

    @Override
    public void search(Weight weight, Filter filter, final Collector collector) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int n = this.starts[i];
            Collector collector2 = new Collector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    collector.setScorer(scorer);
                }

                @Override
                public void collect(int n2) throws IOException {
                    collector.collect(n2);
                }

                @Override
                public void setNextReader(IndexReader indexReader, int n2) throws IOException {
                    collector.setNextReader(indexReader, n + n2);
                }

                @Override
                public boolean acceptsDocsOutOfOrder() {
                    return collector.acceptsDocsOutOfOrder();
                }
            };
            this.searchables[i].search(weight, filter, collector2);
        }
    }

    @Override
    public Query rewrite(Query query) throws IOException {
        Query[] queryArray = new Query[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            queryArray[i] = this.searchables[i].rewrite(query);
        }
        return queryArray[0].combine(queryArray);
    }

    @Override
    public Explanation explain(Weight weight, int n) throws IOException {
        int n2 = this.subSearcher(n);
        return this.searchables[n2].explain(weight, n - this.starts[n2]);
    }

    @Override
    public Weight createNormalizedWeight(Query query) throws IOException {
        Query query2 = this.rewrite(query);
        HashSet<Term> hashSet = new HashSet<Term>();
        query2.extractTerms(hashSet);
        Map<Term, Integer> map = this.createDocFrequencyMap(hashSet);
        int n = this.maxDoc();
        CachedDfSource cachedDfSource = new CachedDfSource(map, n, this.getSimilarity());
        return cachedDfSource.createNormalizedWeight(query2);
    }

    Map<Term, Integer> createDocFrequencyMap(Set<Term> set) throws IOException {
        Term[] termArray = set.toArray(new Term[set.size()]);
        int[] nArray = new int[termArray.length];
        for (Searchable searchable : this.searchables) {
            int[] nArray2 = searchable.docFreqs(termArray);
            for (int i = 0; i < nArray.length; ++i) {
                int n = i;
                nArray[n] = nArray[n] + nArray2[i];
            }
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < termArray.length; ++i) {
            hashMap.put(termArray[i], nArray[i]);
        }
        return hashMap;
    }

    static final class MultiSearcherCallableWithSort
    implements Callable<TopFieldDocs> {
        private final Lock lock;
        private final Searchable searchable;
        private final Weight weight;
        private final Filter filter;
        private final int nDocs;
        private final int i;
        private final FieldDocSortedHitQueue hq;
        private final int[] starts;
        private final Sort sort;

        public MultiSearcherCallableWithSort(Lock lock, Searchable searchable, Weight weight, Filter filter, int n, FieldDocSortedHitQueue fieldDocSortedHitQueue, Sort sort, int n2, int[] nArray) {
            this.lock = lock;
            this.searchable = searchable;
            this.weight = weight;
            this.filter = filter;
            this.nDocs = n;
            this.hq = fieldDocSortedHitQueue;
            this.i = n2;
            this.starts = nArray;
            this.sort = sort;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopFieldDocs call() throws IOException {
            FieldDoc fieldDoc;
            int n;
            TopFieldDocs topFieldDocs = this.searchable.search(this.weight, this.filter, this.nDocs, this.sort);
            for (int i = 0; i < topFieldDocs.fields.length; ++i) {
                if (topFieldDocs.fields[i].getType() != 1) continue;
                for (n = 0; n < topFieldDocs.scoreDocs.length; ++n) {
                    fieldDoc = (FieldDoc)topFieldDocs.scoreDocs[n];
                    fieldDoc.fields[i] = (Integer)fieldDoc.fields[i] + this.starts[this.i];
                }
                break;
            }
            this.lock.lock();
            try {
                this.hq.setFields(topFieldDocs.fields);
            }
            finally {
                this.lock.unlock();
            }
            ScoreDoc[] scoreDocArray = topFieldDocs.scoreDocs;
            for (n = 0; n < scoreDocArray.length; ++n) {
                fieldDoc = (FieldDoc)scoreDocArray[n];
                fieldDoc.doc += this.starts[this.i];
                this.lock.lock();
                try {
                    if (fieldDoc != this.hq.insertWithOverflow(fieldDoc)) continue;
                    break;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return topFieldDocs;
        }
    }

    static final class MultiSearcherCallableNoSort
    implements Callable<TopDocs> {
        private final Lock lock;
        private final Searchable searchable;
        private final Weight weight;
        private final Filter filter;
        private final int nDocs;
        private final int i;
        private final HitQueue hq;
        private final int[] starts;

        public MultiSearcherCallableNoSort(Lock lock, Searchable searchable, Weight weight, Filter filter, int n, HitQueue hitQueue, int n2, int[] nArray) {
            this.lock = lock;
            this.searchable = searchable;
            this.weight = weight;
            this.filter = filter;
            this.nDocs = n;
            this.hq = hitQueue;
            this.i = n2;
            this.starts = nArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs call() throws IOException {
            TopDocs topDocs = this.searchable.search(this.weight, this.filter, this.nDocs);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            for (int i = 0; i < scoreDocArray.length; ++i) {
                ScoreDoc scoreDoc = scoreDocArray[i];
                scoreDoc.doc += this.starts[this.i];
                this.lock.lock();
                try {
                    if (scoreDoc != this.hq.insertWithOverflow(scoreDoc)) continue;
                    break;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return topDocs;
        }
    }

    private static class CachedDfSource
    extends Searcher {
        private final Map<Term, Integer> dfMap;
        private final int maxDoc;

        public CachedDfSource(Map<Term, Integer> map, int n, Similarity similarity) {
            this.dfMap = map;
            this.maxDoc = n;
            this.setSimilarity(similarity);
        }

        @Override
        public int docFreq(Term term) {
            int n;
            try {
                n = this.dfMap.get(term);
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("df for term " + term.text() + " not available");
            }
            return n;
        }

        @Override
        public int[] docFreqs(Term[] termArray) {
            int[] nArray = new int[termArray.length];
            for (int i = 0; i < termArray.length; ++i) {
                nArray[i] = this.docFreq(termArray[i]);
            }
            return nArray;
        }

        @Override
        public int maxDoc() {
            return this.maxDoc;
        }

        @Override
        public Query rewrite(Query query) {
            return query;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Document doc(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Document doc(int n, FieldSelector fieldSelector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Explanation explain(Weight weight, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void search(Weight weight, Filter filter, Collector collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TopDocs search(Weight weight, Filter filter, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) {
            throw new UnsupportedOperationException();
        }
    }
}

