/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ToStringUtils;

public class PhraseQuery
extends Query {
    private String field;
    private ArrayList<Term> terms = new ArrayList(4);
    private ArrayList<Integer> positions = new ArrayList(4);
    private int maxPosition = 0;
    private int slop = 0;

    public void setSlop(int n) {
        this.slop = n;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        int n = 0;
        if (this.positions.size() > 0) {
            n = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(term, n);
    }

    public void add(Term term, int n) {
        if (this.terms.size() == 0) {
            this.field = term.field();
        } else if (term.field() != this.field) {
            throw new IllegalArgumentException("All phrase terms must be in the same field: " + term);
        }
        this.terms.add(term);
        this.positions.add(n);
        if (n > this.maxPosition) {
            this.maxPosition = n;
        }
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    public int[] getPositions() {
        int[] nArray = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            nArray[i] = this.positions.get(i);
        }
        return nArray;
    }

    @Override
    public Query rewrite(IndexReader indexReader) throws IOException {
        if (this.terms.size() == 1) {
            TermQuery termQuery = new TermQuery(this.terms.get(0));
            termQuery.setBoost(this.getBoost());
            return termQuery;
        }
        return super.rewrite(indexReader);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        if (this.terms.size() == 1) {
            Term term = this.terms.get(0);
            TermQuery termQuery = new TermQuery(term);
            termQuery.setBoost(this.getBoost());
            return ((Query)termQuery).createWeight(searcher);
        }
        return new PhraseWeight(searcher);
    }

    @Override
    public void extractTerms(Set<Term> set) {
        set.addAll(this.terms);
    }

    @Override
    public String toString(String string) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.field != null && !this.field.equals(string)) {
            stringBuilder.append(this.field);
            stringBuilder.append(":");
        }
        stringBuilder.append("\"");
        String[] stringArray = new String[this.maxPosition + 1];
        for (n = 0; n < this.terms.size(); ++n) {
            int n2 = this.positions.get(n);
            String string2 = stringArray[n2];
            string2 = string2 == null ? this.terms.get(n).text() : string2 + "|" + this.terms.get(n).text();
            stringArray[n2] = string2;
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string3;
            if (n > 0) {
                stringBuilder.append(' ');
            }
            if ((string3 = stringArray[n]) == null) {
                stringBuilder.append('?');
                continue;
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append("\"");
        if (this.slop != 0) {
            stringBuilder.append("~");
            stringBuilder.append(this.slop);
        }
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PhraseQuery)) {
            return false;
        }
        PhraseQuery phraseQuery = (PhraseQuery)object;
        return this.getBoost() == phraseQuery.getBoost() && this.slop == phraseQuery.slop && this.terms.equals(phraseQuery.terms) && this.positions.equals(phraseQuery.positions);
    }

    @Override
    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.slop ^ this.terms.hashCode() ^ this.positions.hashCode();
    }

    private class PhraseWeight
    extends Weight {
        private final Similarity similarity;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;
        private Explanation.IDFExplanation idfExp;

        public PhraseWeight(Searcher searcher) throws IOException {
            this.similarity = PhraseQuery.this.getSimilarity(searcher);
            this.idfExp = this.similarity.idfExplain(PhraseQuery.this.terms, searcher);
            this.idf = this.idfExp.getIdf();
        }

        public String toString() {
            return "weight(" + PhraseQuery.this + ")";
        }

        @Override
        public Query getQuery() {
            return PhraseQuery.this;
        }

        @Override
        public float getValue() {
            return this.value;
        }

        @Override
        public float sumOfSquaredWeights() {
            this.queryWeight = this.idf * PhraseQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        @Override
        public void normalize(float f) {
            this.queryNorm = f;
            this.queryWeight *= f;
            this.value = this.queryWeight * this.idf;
        }

        @Override
        public Scorer scorer(IndexReader indexReader, boolean bl, boolean bl2) throws IOException {
            if (PhraseQuery.this.terms.size() == 0) {
                return null;
            }
            Comparable[] comparableArray = new PostingsAndFreq[PhraseQuery.this.terms.size()];
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                Term term = (Term)PhraseQuery.this.terms.get(i);
                TermPositions termPositions = indexReader.termPositions(term);
                if (termPositions == null) {
                    return null;
                }
                comparableArray[i] = new PostingsAndFreq(termPositions, indexReader.docFreq(term), (Integer)PhraseQuery.this.positions.get(i), term);
            }
            if (PhraseQuery.this.slop == 0) {
                ArrayUtil.mergeSort((Comparable[])comparableArray);
            }
            if (PhraseQuery.this.slop == 0) {
                ExactPhraseScorer exactPhraseScorer = new ExactPhraseScorer(this, (PostingsAndFreq[])comparableArray, this.similarity, indexReader.norms(PhraseQuery.this.field));
                if (exactPhraseScorer.noDocs) {
                    return null;
                }
                return exactPhraseScorer;
            }
            return new SloppyPhraseScorer(this, (PostingsAndFreq[])comparableArray, this.similarity, PhraseQuery.this.slop, indexReader.norms(PhraseQuery.this.field));
        }

        @Override
        public Explanation explain(IndexReader indexReader, int n) throws IOException {
            Serializable serializable;
            ComplexExplanation complexExplanation = new ComplexExplanation();
            complexExplanation.setDescription("weight(" + this.getQuery() + " in " + n + "), product of:");
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append('\"');
            stringBuilder.append(this.idfExp.explain());
            for (int i = 0; i < PhraseQuery.this.terms.size(); ++i) {
                if (i != 0) {
                    stringBuilder2.append(" ");
                }
                serializable = (Term)PhraseQuery.this.terms.get(i);
                stringBuilder2.append(((Term)serializable).text());
            }
            stringBuilder2.append('\"');
            Explanation explanation = new Explanation(this.idf, "idf(" + PhraseQuery.this.field + ":" + stringBuilder + ")");
            serializable = new Explanation();
            ((Explanation)serializable).setDescription("queryWeight(" + this.getQuery() + "), product of:");
            Explanation explanation2 = new Explanation(PhraseQuery.this.getBoost(), "boost");
            if (PhraseQuery.this.getBoost() != 1.0f) {
                ((Explanation)serializable).addDetail(explanation2);
            }
            ((Explanation)serializable).addDetail(explanation);
            Explanation explanation3 = new Explanation(this.queryNorm, "queryNorm");
            ((Explanation)serializable).addDetail(explanation3);
            ((Explanation)serializable).setValue(explanation2.getValue() * explanation.getValue() * explanation3.getValue());
            complexExplanation.addDetail((Explanation)serializable);
            Explanation explanation4 = new Explanation();
            explanation4.setDescription("fieldWeight(" + PhraseQuery.this.field + ":" + stringBuilder2 + " in " + n + "), product of:");
            Scorer scorer = this.scorer(indexReader, true, false);
            if (scorer == null) {
                return new Explanation(0.0f, "no matching docs");
            }
            Explanation explanation5 = new Explanation();
            int n2 = scorer.advance(n);
            float f = n2 == n ? scorer.freq() : 0.0f;
            explanation5.setValue(this.similarity.tf(f));
            explanation5.setDescription("tf(phraseFreq=" + f + ")");
            explanation4.addDetail(explanation5);
            explanation4.addDetail(explanation);
            Explanation explanation6 = new Explanation();
            byte[] byArray = indexReader.norms(PhraseQuery.this.field);
            float f2 = byArray != null ? this.similarity.decodeNormValue(byArray[n]) : 1.0f;
            explanation6.setValue(f2);
            explanation6.setDescription("fieldNorm(field=" + PhraseQuery.this.field + ", doc=" + n + ")");
            explanation4.addDetail(explanation6);
            explanation4.setValue(explanation5.getValue() * explanation.getValue() * explanation6.getValue());
            complexExplanation.addDetail(explanation4);
            complexExplanation.setValue(((Explanation)serializable).getValue() * explanation4.getValue());
            complexExplanation.setMatch(explanation5.isMatch());
            return complexExplanation;
        }
    }

    static class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        final TermPositions postings;
        final int docFreq;
        final int position;
        final Term term;

        public PostingsAndFreq(TermPositions termPositions, int n, int n2, Term term) {
            this.postings = termPositions;
            this.docFreq = n;
            this.position = n2;
            this.term = term;
        }

        @Override
        public int compareTo(PostingsAndFreq postingsAndFreq) {
            if (this.docFreq == postingsAndFreq.docFreq) {
                if (this.position == postingsAndFreq.position) {
                    return this.term.compareTo(postingsAndFreq.term);
                }
                return this.position - postingsAndFreq.position;
            }
            return this.docFreq - postingsAndFreq.docFreq;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.docFreq;
            n = 31 * n + this.position;
            n = 31 * n + (this.term == null ? 0 : this.term.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PostingsAndFreq postingsAndFreq = (PostingsAndFreq)object;
            if (this.docFreq != postingsAndFreq.docFreq) {
                return false;
            }
            if (this.position != postingsAndFreq.position) {
                return false;
            }
            return !(this.term == null ? postingsAndFreq.term != null : !this.term.equals(postingsAndFreq.term));
        }
    }
}

