/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;

class ReqExclScorer
extends Scorer {
    private Scorer reqScorer;
    private DocIdSetIterator exclDisi;
    private int doc = -1;

    public ReqExclScorer(Scorer scorer, DocIdSetIterator docIdSetIterator) {
        super(scorer.weight);
        this.reqScorer = scorer;
        this.exclDisi = docIdSetIterator;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.reqScorer == null) {
            return this.doc;
        }
        this.doc = this.reqScorer.nextDoc();
        if (this.doc == Integer.MAX_VALUE) {
            this.reqScorer = null;
            return this.doc;
        }
        if (this.exclDisi == null) {
            return this.doc;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }

    private int toNonExcluded() throws IOException {
        int n = this.exclDisi.docID();
        int n2 = this.reqScorer.docID();
        do {
            if (n2 < n) {
                return n2;
            }
            if (n2 <= n) continue;
            n = this.exclDisi.advance(n2);
            if (n == Integer.MAX_VALUE) {
                this.exclDisi = null;
                return n2;
            }
            if (n <= n2) continue;
            return n2;
        } while ((n2 = this.reqScorer.nextDoc()) != Integer.MAX_VALUE);
        this.reqScorer = null;
        return Integer.MAX_VALUE;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        return this.reqScorer.score();
    }

    @Override
    public int advance(int n) throws IOException {
        if (this.reqScorer == null) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (this.exclDisi == null) {
            this.doc = this.reqScorer.advance(n);
            return this.doc;
        }
        if (this.reqScorer.advance(n) == Integer.MAX_VALUE) {
            this.reqScorer = null;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }
}

