/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.util.SmallFloat;
import org.apache.lucene.util.VirtualMethod;

public abstract class Similarity
implements Serializable {
    private static final VirtualMethod<Similarity> withoutDocFreqMethod = new VirtualMethod<Similarity>(Similarity.class, "idfExplain", Term.class, Searcher.class);
    private static final VirtualMethod<Similarity> withDocFreqMethod = new VirtualMethod<Similarity>(Similarity.class, "idfExplain", Term.class, Searcher.class, Integer.TYPE);
    private final boolean hasIDFExplainWithDocFreqAPI = VirtualMethod.compareImplementationDistance(this.getClass(), withDocFreqMethod, withoutDocFreqMethod) >= 0;
    private static Similarity defaultImpl = new DefaultSimilarity();
    public static final int NO_DOC_ID_PROVIDED = -1;
    private static final float[] NORM_TABLE = new float[256];

    public static void setDefault(Similarity similarity) {
        defaultImpl = similarity;
    }

    public static Similarity getDefault() {
        return defaultImpl;
    }

    @Deprecated
    public static float decodeNorm(byte by) {
        return NORM_TABLE[by & 0xFF];
    }

    public float decodeNormValue(byte by) {
        return NORM_TABLE[by & 0xFF];
    }

    @Deprecated
    public static float[] getNormDecoder() {
        return NORM_TABLE;
    }

    public abstract float computeNorm(String var1, FieldInvertState var2);

    @Deprecated
    public final float lengthNorm(String string, int n) {
        throw new UnsupportedOperationException("please use computeNorm instead");
    }

    public abstract float queryNorm(float var1);

    public byte encodeNormValue(float f) {
        return SmallFloat.floatToByte315(f);
    }

    @Deprecated
    public static byte encodeNorm(float f) {
        return SmallFloat.floatToByte315(f);
    }

    public float tf(int n) {
        return this.tf((float)n);
    }

    public abstract float sloppyFreq(int var1);

    public abstract float tf(float var1);

    public Explanation.IDFExplanation idfExplain(Term term, Searcher searcher, int n) throws IOException {
        if (!this.hasIDFExplainWithDocFreqAPI) {
            return this.idfExplain(term, searcher);
        }
        final int n2 = n;
        final int n3 = searcher.maxDoc();
        final float f = this.idf(n2, n3);
        return new Explanation.IDFExplanation(){

            @Override
            public String explain() {
                return "idf(docFreq=" + n2 + ", maxDocs=" + n3 + ")";
            }

            @Override
            public float getIdf() {
                return f;
            }
        };
    }

    public Explanation.IDFExplanation idfExplain(Term term, Searcher searcher) throws IOException {
        return this.idfExplain(term, searcher, searcher.docFreq(term));
    }

    public Explanation.IDFExplanation idfExplain(Collection<Term> collection, Searcher searcher) throws IOException {
        int n = searcher.maxDoc();
        float f = 0.0f;
        final StringBuilder stringBuilder = new StringBuilder();
        for (Term term : collection) {
            int n2 = searcher.docFreq(term);
            f += this.idf(n2, n);
            stringBuilder.append(" ");
            stringBuilder.append(term.text());
            stringBuilder.append("=");
            stringBuilder.append(n2);
        }
        final float f2 = f;
        return new Explanation.IDFExplanation(){

            @Override
            public float getIdf() {
                return f2;
            }

            @Override
            public String explain() {
                return stringBuilder.toString();
            }
        };
    }

    public abstract float idf(int var1, int var2);

    public abstract float coord(int var1, int var2);

    public float scorePayload(int n, String string, int n2, int n3, byte[] byArray, int n4, int n5) {
        return 1.0f;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Similarity.NORM_TABLE[i] = SmallFloat.byte315ToFloat((byte)i);
        }
    }
}

