/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Locale;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.util.StringHelper;

public class SortField
implements Serializable {
    public static final int SCORE = 0;
    public static final int DOC = 1;
    public static final int STRING = 3;
    public static final int INT = 4;
    public static final int FLOAT = 5;
    public static final int LONG = 6;
    public static final int DOUBLE = 7;
    public static final int SHORT = 8;
    public static final int CUSTOM = 9;
    public static final int BYTE = 10;
    public static final int STRING_VAL = 11;
    public static final SortField FIELD_SCORE = new SortField(null, 0);
    public static final SortField FIELD_DOC = new SortField(null, 1);
    private String field;
    private int type;
    private Locale locale;
    boolean reverse = false;
    private FieldCache.Parser parser;
    private FieldComparatorSource comparatorSource;
    private Object missingValue;

    public SortField(String string, int n) {
        this.initFieldType(string, n);
    }

    public SortField(String string, int n, boolean bl) {
        this.initFieldType(string, n);
        this.reverse = bl;
    }

    public SortField(String string, FieldCache.Parser parser) {
        this(string, parser, false);
    }

    public SortField(String string, FieldCache.Parser parser, boolean bl) {
        if (parser instanceof FieldCache.IntParser) {
            this.initFieldType(string, 4);
        } else if (parser instanceof FieldCache.FloatParser) {
            this.initFieldType(string, 5);
        } else if (parser instanceof FieldCache.ShortParser) {
            this.initFieldType(string, 8);
        } else if (parser instanceof FieldCache.ByteParser) {
            this.initFieldType(string, 10);
        } else if (parser instanceof FieldCache.LongParser) {
            this.initFieldType(string, 6);
        } else if (parser instanceof FieldCache.DoubleParser) {
            this.initFieldType(string, 7);
        } else {
            throw new IllegalArgumentException("Parser instance does not subclass existing numeric parser from FieldCache (got " + parser + ")");
        }
        this.reverse = bl;
        this.parser = parser;
    }

    public SortField(String string, Locale locale) {
        this.initFieldType(string, 3);
        this.locale = locale;
    }

    public SortField(String string, Locale locale, boolean bl) {
        this.initFieldType(string, 3);
        this.locale = locale;
        this.reverse = bl;
    }

    public SortField(String string, FieldComparatorSource fieldComparatorSource) {
        this.initFieldType(string, 9);
        this.comparatorSource = fieldComparatorSource;
    }

    public SortField(String string, FieldComparatorSource fieldComparatorSource, boolean bl) {
        this.initFieldType(string, 9);
        this.reverse = bl;
        this.comparatorSource = fieldComparatorSource;
    }

    public SortField setMissingValue(Object object) {
        if (this.type != 10 && this.type != 8 && this.type != 4 && this.type != 5 && this.type != 6 && this.type != 7) {
            throw new IllegalArgumentException("Missing value only works for numeric types");
        }
        this.missingValue = object;
        return this;
    }

    private void initFieldType(String string, int n) {
        this.type = n;
        if (string == null) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException("field can only be null when type is SCORE or DOC");
            }
        } else {
            this.field = StringHelper.intern(string);
        }
    }

    public String getField() {
        return this.field;
    }

    public int getType() {
        return this.type;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public FieldCache.Parser getParser() {
        return this.parser;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    public FieldComparatorSource getComparatorSource() {
        return this.comparatorSource;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case 0: {
                stringBuilder.append("<score>");
                break;
            }
            case 1: {
                stringBuilder.append("<doc>");
                break;
            }
            case 3: {
                stringBuilder.append("<string: \"").append(this.field).append("\">");
                break;
            }
            case 11: {
                stringBuilder.append("<string_val: \"").append(this.field).append("\">");
                break;
            }
            case 10: {
                stringBuilder.append("<byte: \"").append(this.field).append("\">");
                break;
            }
            case 8: {
                stringBuilder.append("<short: \"").append(this.field).append("\">");
                break;
            }
            case 4: {
                stringBuilder.append("<int: \"").append(this.field).append("\">");
                break;
            }
            case 6: {
                stringBuilder.append("<long: \"").append(this.field).append("\">");
                break;
            }
            case 5: {
                stringBuilder.append("<float: \"").append(this.field).append("\">");
                break;
            }
            case 7: {
                stringBuilder.append("<double: \"").append(this.field).append("\">");
                break;
            }
            case 9: {
                stringBuilder.append("<custom:\"").append(this.field).append("\": ").append(this.comparatorSource).append('>');
                break;
            }
            default: {
                stringBuilder.append("<???: \"").append(this.field).append("\">");
            }
        }
        if (this.locale != null) {
            stringBuilder.append('(').append(this.locale).append(')');
        }
        if (this.parser != null) {
            stringBuilder.append('(').append(this.parser).append(')');
        }
        if (this.reverse) {
            stringBuilder.append('!');
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SortField)) {
            return false;
        }
        SortField sortField = (SortField)object;
        return sortField.field == this.field && sortField.type == this.type && sortField.reverse == this.reverse && (sortField.locale == null ? this.locale == null : sortField.locale.equals(this.locale)) && (sortField.comparatorSource == null ? this.comparatorSource == null : sortField.comparatorSource.equals(this.comparatorSource)) && (sortField.parser == null ? this.parser == null : sortField.parser.equals(this.parser));
    }

    public int hashCode() {
        int n = this.type ^ 879060445 + Boolean.valueOf(this.reverse).hashCode() ^ 0xAF5998BB;
        if (this.field != null) {
            n += this.field.hashCode() ^ 0xFF5685DD;
        }
        if (this.locale != null) {
            n += this.locale.hashCode() ^ 0x8150815;
        }
        if (this.comparatorSource != null) {
            n += this.comparatorSource.hashCode();
        }
        if (this.parser != null) {
            n += this.parser.hashCode() ^ 0x3AAF56FF;
        }
        return n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.field != null) {
            this.field = StringHelper.intern(this.field);
        }
    }

    public FieldComparator getComparator(int n, int n2) throws IOException {
        if (this.locale != null) {
            return new FieldComparator.StringComparatorLocale(n, this.field, this.locale);
        }
        switch (this.type) {
            case 0: {
                return new FieldComparator.RelevanceComparator(n);
            }
            case 1: {
                return new FieldComparator.DocComparator(n);
            }
            case 4: {
                return new FieldComparator.IntComparator(n, this.field, this.parser, (Integer)this.missingValue);
            }
            case 5: {
                return new FieldComparator.FloatComparator(n, this.field, this.parser, (Float)this.missingValue);
            }
            case 6: {
                return new FieldComparator.LongComparator(n, this.field, this.parser, (Long)this.missingValue);
            }
            case 7: {
                return new FieldComparator.DoubleComparator(n, this.field, this.parser, (Double)this.missingValue);
            }
            case 10: {
                return new FieldComparator.ByteComparator(n, this.field, this.parser, (Byte)this.missingValue);
            }
            case 8: {
                return new FieldComparator.ShortComparator(n, this.field, this.parser, (Short)this.missingValue);
            }
            case 9: {
                assert (this.comparatorSource != null);
                return this.comparatorSource.newComparator(this.field, n, n2, this.reverse);
            }
            case 3: {
                return new FieldComparator.StringOrdValComparator(n, this.field, n2, this.reverse);
            }
            case 11: {
                return new FieldComparator.StringValComparator(n, this.field);
            }
        }
        throw new IllegalStateException("Illegal sort type: " + this.type);
    }
}

