/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;

abstract class TermCollectingRewrite<Q extends Query>
extends MultiTermQuery.RewriteMethod {
    TermCollectingRewrite() {
    }

    protected abstract Q getTopLevelQuery() throws IOException;

    protected abstract void addClause(Q var1, Term var2, float var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void collectTerms(IndexReader indexReader, MultiTermQuery multiTermQuery, TermCollector termCollector) throws IOException {
        FilteredTermEnum filteredTermEnum = multiTermQuery.getEnum(indexReader);
        try {
            Term term;
            while ((term = filteredTermEnum.term()) != null) {
                if (!termCollector.collect(term, filteredTermEnum.difference())) {
                } else if (filteredTermEnum.next()) continue;
                break;
            }
        }
        finally {
            filteredTermEnum.close();
        }
    }

    protected static interface TermCollector {
        public boolean collect(Term var1, float var2) throws IOException;
    }
}

