/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.util.StringHelper;

public class TermRangeTermEnum
extends FilteredTermEnum {
    private Collator collator = null;
    private boolean endEnum = false;
    private String field;
    private String upperTermText;
    private String lowerTermText;
    private boolean includeLower;
    private boolean includeUpper;

    public TermRangeTermEnum(IndexReader indexReader, String string, String string2, String string3, boolean bl, boolean bl2, Collator collator) throws IOException {
        this.collator = collator;
        this.upperTermText = string3;
        this.lowerTermText = string2;
        this.includeLower = bl;
        this.includeUpper = bl2;
        this.field = StringHelper.intern(string);
        if (this.lowerTermText == null) {
            this.lowerTermText = "";
            this.includeLower = true;
        }
        if (this.upperTermText == null) {
            this.includeUpper = true;
        }
        String string4 = collator == null ? this.lowerTermText : "";
        this.setEnum(indexReader.terms(new Term(this.field, string4)));
    }

    @Override
    public float difference() {
        return 1.0f;
    }

    @Override
    protected boolean endEnum() {
        return this.endEnum;
    }

    @Override
    protected boolean termCompare(Term term) {
        if (this.collator == null) {
            boolean bl = false;
            if (!this.includeLower) {
                bl = true;
            }
            if (term != null && term.field() == this.field) {
                if (!bl || null == this.lowerTermText || term.text().compareTo(this.lowerTermText) > 0) {
                    int n;
                    bl = false;
                    if (this.upperTermText != null && ((n = this.upperTermText.compareTo(term.text())) < 0 || !this.includeUpper && n == 0)) {
                        this.endEnum = true;
                        return false;
                    }
                    return true;
                }
            } else {
                this.endEnum = true;
                return false;
            }
            return false;
        }
        if (term != null && term.field() == this.field) {
            return (this.lowerTermText == null || (this.includeLower ? this.collator.compare(term.text(), this.lowerTermText) >= 0 : this.collator.compare(term.text(), this.lowerTermText) > 0)) && (this.upperTermText == null || (this.includeUpper ? this.collator.compare(term.text(), this.upperTermText) <= 0 : this.collator.compare(term.text(), this.upperTermText) < 0));
        }
        this.endEnum = true;
        return false;
    }
}

