/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopDocsCollector<T extends ScoreDoc>
extends Collector {
    protected static final TopDocs EMPTY_TOPDOCS = new TopDocs(0, new ScoreDoc[0], Float.NaN);
    protected PriorityQueue<T> pq;
    protected int totalHits;

    protected TopDocsCollector(PriorityQueue<T> priorityQueue) {
        this.pq = priorityQueue;
    }

    protected void populateResults(ScoreDoc[] scoreDocArray, int n) {
        for (int i = n - 1; i >= 0; --i) {
            scoreDocArray[i] = (ScoreDoc)this.pq.pop();
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n) {
        return scoreDocArray == null ? EMPTY_TOPDOCS : new TopDocs(this.totalHits, scoreDocArray);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    protected int topDocsSize() {
        return this.totalHits < this.pq.size() ? this.totalHits : this.pq.size();
    }

    public TopDocs topDocs() {
        return this.topDocs(0, this.topDocsSize());
    }

    public TopDocs topDocs(int n) {
        return this.topDocs(n, this.topDocsSize());
    }

    public TopDocs topDocs(int n, int n2) {
        int n3 = this.topDocsSize();
        if (n < 0 || n >= n3 || n2 <= 0) {
            return this.newTopDocs(null, n);
        }
        n2 = Math.min(n3 - n, n2);
        ScoreDoc[] scoreDocArray = new ScoreDoc[n2];
        for (int i = this.pq.size() - n - n2; i > 0; --i) {
            this.pq.pop();
        }
        this.populateResults(scoreDocArray, n2);
        return this.newTopDocs(scoreDocArray, n);
    }
}

