/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    private final boolean fillFields;
    float maxScore = Float.NaN;
    final int numHits;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;

    private TopFieldCollector(PriorityQueue<FieldValueHitQueue.Entry> priorityQueue, int n, boolean bl) {
        super(priorityQueue);
        this.numHits = n;
        this.fillFields = bl;
    }

    public static TopFieldCollector create(Sort sort, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue = FieldValueHitQueue.create(sort.fields, n);
        if (fieldValueHitQueue.getComparators().length == 1) {
            if (bl4) {
                if (bl3) {
                    return new OneComparatorScoringMaxScoreCollector(fieldValueHitQueue, n, bl);
                }
                if (bl2) {
                    return new OneComparatorScoringNoMaxScoreCollector(fieldValueHitQueue, n, bl);
                }
                return new OneComparatorNonScoringCollector(fieldValueHitQueue, n, bl);
            }
            if (bl3) {
                return new OutOfOrderOneComparatorScoringMaxScoreCollector(fieldValueHitQueue, n, bl);
            }
            if (bl2) {
                return new OutOfOrderOneComparatorScoringNoMaxScoreCollector(fieldValueHitQueue, n, bl);
            }
            return new OutOfOrderOneComparatorNonScoringCollector(fieldValueHitQueue, n, bl);
        }
        if (bl4) {
            if (bl3) {
                return new MultiComparatorScoringMaxScoreCollector(fieldValueHitQueue, n, bl);
            }
            if (bl2) {
                return new MultiComparatorScoringNoMaxScoreCollector(fieldValueHitQueue, n, bl);
            }
            return new MultiComparatorNonScoringCollector(fieldValueHitQueue, n, bl);
        }
        if (bl3) {
            return new OutOfOrderMultiComparatorScoringMaxScoreCollector(fieldValueHitQueue, n, bl);
        }
        if (bl2) {
            return new OutOfOrderMultiComparatorScoringNoMaxScoreCollector(fieldValueHitQueue, n, bl);
        }
        return new OutOfOrderMultiComparatorNonScoringCollector(fieldValueHitQueue, n, bl);
    }

    final void add(int n, int n2, float f) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(n, this.docBase + n2, f));
        this.queueFull = this.totalHits == this.numHits;
    }

    @Override
    protected void populateResults(ScoreDoc[] scoreDocArray, int n) {
        if (this.fillFields) {
            FieldValueHitQueue fieldValueHitQueue = (FieldValueHitQueue)this.pq;
            for (int i = n - 1; i >= 0; --i) {
                scoreDocArray[i] = fieldValueHitQueue.fillFields((FieldValueHitQueue.Entry)fieldValueHitQueue.pop());
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                FieldValueHitQueue.Entry entry = (FieldValueHitQueue.Entry)this.pq.pop();
                scoreDocArray[i] = new FieldDoc(entry.doc, entry.score);
            }
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n) {
        if (scoreDocArray == null) {
            scoreDocArray = EMPTY_SCOREDOCS;
            this.maxScore = Float.NaN;
        }
        return new TopFieldDocs(this.totalHits, scoreDocArray, ((FieldValueHitQueue)this.pq).getFields(), this.maxScore);
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    private static final class OutOfOrderMultiComparatorScoringNoMaxScoreCollector
    extends MultiComparatorScoringNoMaxScoreCollector {
        public OutOfOrderMultiComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            block8: {
                block7: {
                    int n2;
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int n3 = 0;
                    while (true) {
                        if ((n2 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n2 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            if (n + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    float f = this.scorer.score();
                    this.updateBottom(n, f);
                    for (n2 = 0; n2 < this.comparators.length; ++n2) {
                        this.comparators[n2].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int n4 = this.totalHits - 1;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].copy(n4, n);
                }
                float f = this.scorer.score();
                this.add(n4, n, f);
                if (!this.queueFull) break block8;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class MultiComparatorScoringNoMaxScoreCollector
    extends MultiComparatorNonScoringCollector {
        Scorer scorer;

        public MultiComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        final void updateBottom(int n, float f) {
            this.bottom.doc = this.docBase + n;
            this.bottom.score = f;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            block8: {
                block7: {
                    int n2;
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int n3 = 0;
                    while (true) {
                        if ((n2 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n2 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    float f = this.scorer.score();
                    this.updateBottom(n, f);
                    for (n2 = 0; n2 < this.comparators.length; ++n2) {
                        this.comparators[n2].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int n4 = this.totalHits - 1;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].copy(n4, n);
                }
                float f = this.scorer.score();
                this.add(n4, n, f);
                if (!this.queueFull) break block8;
                for (int i = 0; i < this.comparators.length; ++i) {
                    this.comparators[i].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    private static final class OutOfOrderMultiComparatorScoringMaxScoreCollector
    extends MultiComparatorScoringMaxScoreCollector {
        public OutOfOrderMultiComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            block9: {
                int n2;
                float f;
                block8: {
                    f = this.scorer.score();
                    if (f > this.maxScore) {
                        this.maxScore = f;
                    }
                    ++this.totalHits;
                    if (!this.queueFull) break block8;
                    int n3 = 0;
                    while (true) {
                        int n4;
                        if ((n4 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n4 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            if (n + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    this.updateBottom(n, f);
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].setBottom(this.bottom.slot);
                    }
                    break block9;
                }
                int n5 = this.totalHits - 1;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].copy(n5, n);
                }
                this.add(n5, n, f);
                if (!this.queueFull) break block9;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class MultiComparatorScoringMaxScoreCollector
    extends MultiComparatorNonScoringCollector {
        Scorer scorer;

        public MultiComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
            this.maxScore = Float.NEGATIVE_INFINITY;
        }

        final void updateBottom(int n, float f) {
            this.bottom.doc = this.docBase + n;
            this.bottom.score = f;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            block9: {
                int n2;
                float f;
                block8: {
                    f = this.scorer.score();
                    if (f > this.maxScore) {
                        this.maxScore = f;
                    }
                    ++this.totalHits;
                    if (!this.queueFull) break block8;
                    int n3 = 0;
                    while (true) {
                        int n4;
                        if ((n4 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n4 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    this.updateBottom(n, f);
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].setBottom(this.bottom.slot);
                    }
                    break block9;
                }
                int n5 = this.totalHits - 1;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].copy(n5, n);
                }
                this.add(n5, n, f);
                if (!this.queueFull) break block9;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    private static class OutOfOrderMultiComparatorNonScoringCollector
    extends MultiComparatorNonScoringCollector {
        public OutOfOrderMultiComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            block8: {
                int n2;
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int n3 = 0;
                    while (true) {
                        int n4;
                        if ((n4 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n4 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            if (n + this.docBase <= this.bottom.doc) break;
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    this.updateBottom(n);
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int n5 = this.totalHits - 1;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].copy(n5, n);
                }
                this.add(n5, n, Float.NaN);
                if (!this.queueFull) break block8;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class MultiComparatorNonScoringCollector
    extends TopFieldCollector {
        final FieldComparator[] comparators;
        final int[] reverseMul;

        public MultiComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
            this.comparators = fieldValueHitQueue.getComparators();
            this.reverseMul = fieldValueHitQueue.getReverseMul();
        }

        final void updateBottom(int n) {
            this.bottom.doc = this.docBase + n;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            block8: {
                int n2;
                block7: {
                    ++this.totalHits;
                    if (!this.queueFull) break block7;
                    int n3 = 0;
                    while (true) {
                        int n4;
                        if ((n4 = this.reverseMul[n3] * this.comparators[n3].compareBottom(n)) < 0) {
                            return;
                        }
                        if (n4 > 0) break;
                        if (n3 == this.comparators.length - 1) {
                            return;
                        }
                        ++n3;
                    }
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].copy(this.bottom.slot, n);
                    }
                    this.updateBottom(n);
                    for (n3 = 0; n3 < this.comparators.length; ++n3) {
                        this.comparators[n3].setBottom(this.bottom.slot);
                    }
                    break block8;
                }
                int n5 = this.totalHits - 1;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].copy(n5, n);
                }
                this.add(n5, n, Float.NaN);
                if (!this.queueFull) break block8;
                for (n2 = 0; n2 < this.comparators.length; ++n2) {
                    this.comparators[n2].setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.docBase = n;
            for (int i = 0; i < this.comparators.length; ++i) {
                this.comparators[i].setNextReader(indexReader, n);
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            for (int i = 0; i < this.comparators.length; ++i) {
                this.comparators[i].setScorer(scorer);
            }
        }
    }

    private static class OutOfOrderOneComparatorScoringMaxScoreCollector
    extends OneComparatorScoringMaxScoreCollector {
        public OutOfOrderOneComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            if (f > this.maxScore) {
                this.maxScore = f;
            }
            ++this.totalHits;
            if (this.queueFull) {
                int n2 = this.reverseMul * this.comparator.compareBottom(n);
                if (n2 < 0 || n2 == 0 && n + this.docBase > this.bottom.doc) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n, f);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int n3 = this.totalHits - 1;
                this.comparator.copy(n3, n);
                this.add(n3, n, f);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class OneComparatorScoringMaxScoreCollector
    extends OneComparatorNonScoringCollector {
        Scorer scorer;

        public OneComparatorScoringMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
            this.maxScore = Float.NEGATIVE_INFINITY;
        }

        final void updateBottom(int n, float f) {
            this.bottom.doc = this.docBase + n;
            this.bottom.score = f;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            float f = this.scorer.score();
            if (f > this.maxScore) {
                this.maxScore = f;
            }
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(n) <= 0) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n, f);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int n2 = this.totalHits - 1;
                this.comparator.copy(n2, n);
                this.add(n2, n, f);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }
    }

    private static class OutOfOrderOneComparatorScoringNoMaxScoreCollector
    extends OneComparatorScoringNoMaxScoreCollector {
        public OutOfOrderOneComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                int n2 = this.reverseMul * this.comparator.compareBottom(n);
                if (n2 < 0 || n2 == 0 && n + this.docBase > this.bottom.doc) {
                    return;
                }
                float f = this.scorer.score();
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n, f);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                float f = this.scorer.score();
                int n3 = this.totalHits - 1;
                this.comparator.copy(n3, n);
                this.add(n3, n, f);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class OneComparatorScoringNoMaxScoreCollector
    extends OneComparatorNonScoringCollector {
        Scorer scorer;

        public OneComparatorScoringNoMaxScoreCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        final void updateBottom(int n, float f) {
            this.bottom.doc = this.docBase + n;
            this.bottom.score = f;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(n) <= 0) {
                    return;
                }
                float f = this.scorer.score();
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n, f);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                float f = this.scorer.score();
                int n2 = this.totalHits - 1;
                this.comparator.copy(n2, n);
                this.add(n2, n, f);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            this.comparator.setScorer(scorer);
        }
    }

    private static class OutOfOrderOneComparatorNonScoringCollector
    extends OneComparatorNonScoringCollector {
        public OutOfOrderOneComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
        }

        @Override
        public void collect(int n) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                int n2 = this.reverseMul * this.comparator.compareBottom(n);
                if (n2 < 0 || n2 == 0 && n + this.docBase > this.bottom.doc) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int n3 = this.totalHits - 1;
                this.comparator.copy(n3, n);
                this.add(n3, n, Float.NaN);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }

    private static class OneComparatorNonScoringCollector
    extends TopFieldCollector {
        final FieldComparator comparator;
        final int reverseMul;

        public OneComparatorNonScoringCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> fieldValueHitQueue, int n, boolean bl) throws IOException {
            super(fieldValueHitQueue, n, bl);
            this.comparator = fieldValueHitQueue.getComparators()[0];
            this.reverseMul = fieldValueHitQueue.getReverseMul()[0];
        }

        final void updateBottom(int n) {
            this.bottom.doc = this.docBase + n;
            this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
        }

        @Override
        public void collect(int n) throws IOException {
            ++this.totalHits;
            if (this.queueFull) {
                if (this.reverseMul * this.comparator.compareBottom(n) <= 0) {
                    return;
                }
                this.comparator.copy(this.bottom.slot, n);
                this.updateBottom(n);
                this.comparator.setBottom(this.bottom.slot);
            } else {
                int n2 = this.totalHits - 1;
                this.comparator.copy(n2, n);
                this.add(n2, n, Float.NaN);
                if (this.queueFull) {
                    this.comparator.setBottom(this.bottom.slot);
                }
            }
        }

        @Override
        public void setNextReader(IndexReader indexReader, int n) throws IOException {
            this.docBase = n;
            this.comparator.setNextReader(indexReader, n);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.comparator.setScorer(scorer);
        }
    }
}

