/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.function.DocValues;
import org.apache.lucene.search.function.FieldCacheSource;

public class IntFieldSource
extends FieldCacheSource {
    private FieldCache.IntParser parser;

    public IntFieldSource(String string) {
        this(string, null);
    }

    public IntFieldSource(String string, FieldCache.IntParser intParser) {
        super(string);
        this.parser = intParser;
    }

    @Override
    public String description() {
        return "int(" + super.description() + ')';
    }

    @Override
    public DocValues getCachedFieldValues(FieldCache fieldCache, String string, IndexReader indexReader) throws IOException {
        final int[] nArray = fieldCache.getInts(indexReader, string, this.parser);
        return new DocValues(){

            @Override
            public float floatVal(int n) {
                return nArray[n];
            }

            @Override
            public int intVal(int n) {
                return nArray[n];
            }

            @Override
            public String toString(int n) {
                return IntFieldSource.this.description() + '=' + this.intVal(n);
            }

            @Override
            Object getInnerArray() {
                return nArray;
            }
        };
    }

    @Override
    public boolean cachedFieldSourceEquals(FieldCacheSource fieldCacheSource) {
        if (fieldCacheSource.getClass() != IntFieldSource.class) {
            return false;
        }
        IntFieldSource intFieldSource = (IntFieldSource)fieldCacheSource;
        return this.parser == null ? intFieldSource.parser == null : this.parser.getClass() == intFieldSource.parser.getClass();
    }

    @Override
    public int cachedFieldSourceHashCode() {
        return this.parser == null ? Integer.class.hashCode() : this.parser.getClass().hashCode();
    }
}

