/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanPositionCheckQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class SpanPayloadCheckQuery
extends SpanPositionCheckQuery {
    protected final Collection<byte[]> payloadToMatch;

    public SpanPayloadCheckQuery(SpanQuery spanQuery, Collection<byte[]> collection) {
        super(spanQuery);
        if (spanQuery instanceof SpanNearQuery) {
            throw new IllegalArgumentException("SpanNearQuery not allowed");
        }
        this.payloadToMatch = collection;
    }

    @Override
    protected SpanPositionCheckQuery.AcceptStatus acceptPosition(Spans spans) throws IOException {
        boolean bl = spans.isPayloadAvailable();
        if (bl) {
            Collection<byte[]> collection = spans.getPayload();
            if (collection.size() == this.payloadToMatch.size()) {
                Iterator<byte[]> iterator = this.payloadToMatch.iterator();
                for (byte[] byArray : collection) {
                    if (Arrays.equals(byArray, iterator.next())) continue;
                    return SpanPositionCheckQuery.AcceptStatus.NO;
                }
                return SpanPositionCheckQuery.AcceptStatus.YES;
            }
            return SpanPositionCheckQuery.AcceptStatus.NO;
        }
        return SpanPositionCheckQuery.AcceptStatus.YES;
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("spanPayCheck(");
        stringBuilder.append(this.match.toString(string));
        stringBuilder.append(", payloadRef: ");
        for (byte[] byArray : this.payloadToMatch) {
            ToStringUtils.byteArray(stringBuilder, byArray);
            stringBuilder.append(';');
        }
        stringBuilder.append(")");
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public Object clone() {
        SpanPayloadCheckQuery spanPayloadCheckQuery = new SpanPayloadCheckQuery((SpanQuery)this.match.clone(), this.payloadToMatch);
        spanPayloadCheckQuery.setBoost(this.getBoost());
        return spanPayloadCheckQuery;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpanPayloadCheckQuery)) {
            return false;
        }
        SpanPayloadCheckQuery spanPayloadCheckQuery = (SpanPayloadCheckQuery)object;
        return ((Object)this.payloadToMatch).equals(spanPayloadCheckQuery.payloadToMatch) && this.match.equals(spanPayloadCheckQuery.match) && this.getBoost() == spanPayloadCheckQuery.getBoost();
    }

    @Override
    public int hashCode() {
        int n = this.match.hashCode();
        n ^= n << 8 | n >>> 25;
        n ^= ((Object)this.payloadToMatch).hashCode();
        return n ^= Float.floatToRawIntBits(this.getBoost());
    }
}

