/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.IndexInput;

public class ChecksumIndexInput
extends IndexInput {
    IndexInput main;
    Checksum digest;

    public ChecksumIndexInput(IndexInput indexInput) {
        super("ChecksumIndexInput(" + indexInput + ")");
        this.main = indexInput;
        this.digest = new CRC32();
    }

    @Override
    public byte readByte() throws IOException {
        byte by = this.main.readByte();
        this.digest.update(by);
        return by;
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        this.main.readBytes(byArray, n, n2);
        this.digest.update(byArray, n, n2);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public void close() throws IOException {
        this.main.close();
    }

    @Override
    public long getFilePointer() {
        return this.main.getFilePointer();
    }

    @Override
    public void seek(long l) {
        throw new RuntimeException("not allowed");
    }

    @Override
    public long length() {
        return this.main.length();
    }
}

