/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.DataInput;

public class InputStreamDataInput
extends DataInput
implements Closeable {
    private final InputStream is;

    public InputStreamDataInput(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    public byte readByte() throws IOException {
        int n = this.is.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.is.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

