/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.IOUtils;

public class NRTCachingDirectory
extends Directory {
    private final RAMDirectory cache = new RAMDirectory();
    private final Directory delegate;
    private final long maxMergeSizeBytes;
    private final long maxCachedBytes;
    private static final boolean VERBOSE = false;
    private final ConcurrentHashMap<Thread, MergePolicy.OneMerge> merges = new ConcurrentHashMap();

    public NRTCachingDirectory(Directory directory, double d, double d2) {
        this.delegate = directory;
        this.maxMergeSizeBytes = (long)(d * 1024.0 * 1024.0);
        this.maxCachedBytes = (long)(d2 * 1024.0 * 1024.0);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.delegate.getLockFactory();
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.delegate.setLockFactory(lockFactory);
    }

    @Override
    public String getLockID() {
        return this.delegate.getLockID();
    }

    @Override
    public Lock makeLock(String string) {
        return this.delegate.makeLock(string);
    }

    @Override
    public void clearLock(String string) throws IOException {
        this.delegate.clearLock(string);
    }

    @Override
    public String toString() {
        return "NRTCachingDirectory(" + this.delegate + "; maxCacheMB=" + (double)(this.maxCachedBytes / 1024L) / 1024.0 + " maxMergeSizeMB=" + (double)(this.maxMergeSizeBytes / 1024L) / 1024.0 + ")";
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        HashSet<String> hashSet;
        block4: {
            hashSet = new HashSet<String>();
            for (String string : this.cache.listAll()) {
                hashSet.add(string);
            }
            try {
                for (String string : this.delegate.listAll()) {
                    hashSet.add(string);
                }
            }
            catch (NoSuchDirectoryException noSuchDirectoryException) {
                if (!hashSet.isEmpty()) break block4;
                throw noSuchDirectoryException;
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public long sizeInBytes() {
        return this.cache.sizeInBytes();
    }

    @Override
    public synchronized boolean fileExists(String string) throws IOException {
        return this.cache.fileExists(string) || this.delegate.fileExists(string);
    }

    @Override
    public synchronized long fileModified(String string) throws IOException {
        if (this.cache.fileExists(string)) {
            return this.cache.fileModified(string);
        }
        return this.delegate.fileModified(string);
    }

    @Override
    @Deprecated
    public synchronized void touchFile(String string) throws IOException {
        if (this.cache.fileExists(string)) {
            this.cache.touchFile(string);
        } else {
            this.delegate.touchFile(string);
        }
    }

    @Override
    public synchronized void deleteFile(String string) throws IOException {
        if (this.cache.fileExists(string)) {
            assert (!this.delegate.fileExists(string));
            this.cache.deleteFile(string);
        } else {
            this.delegate.deleteFile(string);
        }
    }

    @Override
    public synchronized long fileLength(String string) throws IOException {
        if (this.cache.fileExists(string)) {
            return this.cache.fileLength(string);
        }
        return this.delegate.fileLength(string);
    }

    public String[] listCachedFiles() {
        return this.cache.listAll();
    }

    @Override
    public IndexOutput createOutput(String string) throws IOException {
        if (this.doCacheWrite(string)) {
            return this.cache.createOutput(string);
        }
        return this.delegate.createOutput(string);
    }

    @Override
    public void sync(Collection<String> collection) throws IOException {
        for (String string : collection) {
            this.unCache(string);
        }
        this.delegate.sync(collection);
    }

    @Override
    public synchronized IndexInput openInput(String string) throws IOException {
        if (this.cache.fileExists(string)) {
            return this.cache.openInput(string);
        }
        return this.delegate.openInput(string);
    }

    @Override
    public synchronized IndexInput openInput(String string, int n) throws IOException {
        if (this.cache.fileExists(string)) {
            return this.cache.openInput(string, n);
        }
        return this.delegate.openInput(string, n);
    }

    @Override
    public void close() throws IOException {
        for (String string : this.cache.listAll()) {
            this.unCache(string);
        }
        this.cache.close();
        this.delegate.close();
    }

    public MergeScheduler getMergeScheduler() {
        return new ConcurrentMergeScheduler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doMerge(MergePolicy.OneMerge oneMerge) throws IOException {
                try {
                    NRTCachingDirectory.this.merges.put(Thread.currentThread(), oneMerge);
                    super.doMerge(oneMerge);
                }
                finally {
                    NRTCachingDirectory.this.merges.remove(Thread.currentThread());
                }
            }
        };
    }

    protected boolean doCacheWrite(String string) {
        MergePolicy.OneMerge oneMerge = this.merges.get(Thread.currentThread());
        return !string.equals("segments.gen") && (oneMerge == null || oneMerge.estimatedMergeBytes <= this.maxMergeSizeBytes) && this.cache.sizeInBytes() <= this.maxCachedBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unCache(String string) throws IOException {
        block11: {
            IndexOutput indexOutput;
            Closeable closeable = this;
            synchronized (closeable) {
                if (!this.delegate.fileExists(string)) {
                    assert (this.cache.fileExists(string));
                    indexOutput = this.delegate.createOutput(string);
                } else {
                    indexOutput = null;
                }
            }
            if (indexOutput == null) break block11;
            closeable = null;
            try {
                closeable = this.cache.openInput(string);
                ((IndexInput)closeable).copyBytes(indexOutput, ((IndexInput)closeable).length());
            }
            catch (Throwable throwable) {
                IOUtils.close(closeable, indexOutput);
                throw throwable;
            }
            IOUtils.close(closeable, indexOutput);
            NRTCachingDirectory nRTCachingDirectory = this;
            synchronized (nRTCachingDirectory) {
                this.cache.deleteFile(string);
            }
        }
    }
}

