/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLock;

public class NativeFSLockFactory
extends FSLockFactory {
    public NativeFSLockFactory() throws IOException {
        this((File)null);
    }

    public NativeFSLockFactory(String string) throws IOException {
        this(new File(string));
    }

    public NativeFSLockFactory(File file) throws IOException {
        this.setLockDir(file);
    }

    @Override
    public synchronized Lock makeLock(String string) {
        if (this.lockPrefix != null) {
            string = this.lockPrefix + "-" + string;
        }
        return new NativeFSLock(this.lockDir, string);
    }

    @Override
    public void clearLock(String string) throws IOException {
        if (this.lockDir.exists()) {
            this.makeLock(string).release();
            if (this.lockPrefix != null) {
                string = this.lockPrefix + "-" + string;
            }
            new File(this.lockDir, string).delete();
        }
    }
}

