/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;

public class RAMOutputStream
extends IndexOutput {
    static final int BUFFER_SIZE = 1024;
    private RAMFile file;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMOutputStream() {
        this(new RAMFile());
    }

    public RAMOutputStream(RAMFile rAMFile) {
        this.file = rAMFile;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    public void writeTo(IndexOutput indexOutput) throws IOException {
        this.flush();
        long l = this.file.length;
        long l2 = 0L;
        int n = 0;
        while (l2 < l) {
            int n2 = 1024;
            long l3 = l2 + (long)n2;
            if (l3 > l) {
                n2 = (int)(l - l2);
            }
            indexOutput.writeBytes(this.file.getBuffer(n++), n2);
            l2 = l3;
        }
    }

    public void reset() {
        this.currentBuffer = null;
        this.currentBufferIndex = -1;
        this.bufferPosition = 0;
        this.bufferStart = 0L;
        this.bufferLength = 0;
        this.file.setLength(0L);
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void seek(long l) throws IOException {
        this.setFileLength();
        if (l < this.bufferStart || l >= this.bufferStart + (long)this.bufferLength) {
            this.currentBufferIndex = (int)(l / 1024L);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(l % 1024L);
    }

    @Override
    public long length() {
        return this.file.length;
    }

    @Override
    public void writeByte(byte by) throws IOException {
        if (this.bufferPosition == this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        this.currentBuffer[this.bufferPosition++] = by;
    }

    @Override
    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        assert (byArray != null);
        while (n2 > 0) {
            int n3;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int n4 = n2 < (n3 = this.currentBuffer.length - this.bufferPosition) ? n2 : n3;
            System.arraycopy(byArray, n, this.currentBuffer, this.bufferPosition, n4);
            n += n4;
            n2 -= n4;
            this.bufferPosition += n4;
        }
    }

    private final void switchCurrentBuffer() throws IOException {
        this.currentBuffer = this.currentBufferIndex == this.file.numBuffers() ? this.file.addBuffer(1024) : this.file.getBuffer(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        this.bufferLength = this.currentBuffer.length;
    }

    private void setFileLength() {
        long l = this.bufferStart + (long)this.bufferPosition;
        if (l > this.file.length) {
            this.file.setLength(l);
        }
    }

    @Override
    public void flush() throws IOException {
        this.file.setLastModified(System.currentTimeMillis());
        this.setFileLength();
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    public long sizeInBytes() {
        return this.file.numBuffers() * 1024;
    }

    @Override
    public void copyBytes(DataInput dataInput, long l) throws IOException {
        assert (l >= 0L) : "numBytes=" + l;
        while (l > 0L) {
            int n;
            if (this.bufferPosition == this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            if (l < (long)(n = this.currentBuffer.length - this.bufferPosition)) {
                n = (int)l;
            }
            dataInput.readBytes(this.currentBuffer, this.bufferPosition, n, false);
            l -= (long)n;
            this.bufferPosition += n;
        }
    }
}

