/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;

public class SimpleFSDirectory
extends FSDirectory {
    public SimpleFSDirectory(File file, LockFactory lockFactory) throws IOException {
        super(file, lockFactory);
    }

    public SimpleFSDirectory(File file) throws IOException {
        super(file, null);
    }

    @Override
    public IndexInput openInput(String string, int n) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, string);
        return new SimpleFSIndexInput("SimpleFSIndexInput(path=\"" + file.getPath() + "\")", file, n, this.getReadChunkSize());
    }

    protected static class SimpleFSIndexInput
    extends BufferedIndexInput {
        protected final Descriptor file;
        boolean isClone;
        protected final int chunkSize;

        @Deprecated
        public SimpleFSIndexInput(File file, int n, int n2) throws IOException {
            this("anonymous SimpleFSIndexInput", file, n, n2);
        }

        public SimpleFSIndexInput(String string, File file, int n, int n2) throws IOException {
            super(string, n);
            this.file = new Descriptor(file, "r");
            this.chunkSize = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readInternal(byte[] byArray, int n, int n2) throws IOException {
            Descriptor descriptor = this.file;
            synchronized (descriptor) {
                long l = this.getFilePointer();
                if (l != this.file.position) {
                    this.file.seek(l);
                    this.file.position = l;
                }
                int n3 = 0;
                try {
                    int n4;
                    do {
                        int n5;
                        if ((n4 = this.file.read(byArray, n + n3, n5 = n3 + this.chunkSize > n2 ? n2 - n3 : this.chunkSize)) == -1) {
                            throw new IOException("read past EOF");
                        }
                        this.file.position += (long)n4;
                    } while ((n3 += n4) < n2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    OutOfMemoryError outOfMemoryError2 = new OutOfMemoryError("OutOfMemoryError likely caused by the Sun VM Bug described in https://issues.apache.org/jira/browse/LUCENE-1566; try calling FSDirectory.setReadChunkSize with a value smaller than the current chunk size (" + this.chunkSize + ")");
                    outOfMemoryError2.initCause(outOfMemoryError);
                    throw outOfMemoryError2;
                }
                catch (IOException iOException) {
                    IOException iOException2 = new IOException(iOException.getMessage() + ": " + this);
                    iOException2.initCause(iOException);
                    throw iOException2;
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (!this.isClone) {
                this.file.close();
            }
        }

        @Override
        protected void seekInternal(long l) {
        }

        @Override
        public long length() {
            return this.file.length;
        }

        @Override
        public Object clone() {
            SimpleFSIndexInput simpleFSIndexInput = (SimpleFSIndexInput)super.clone();
            simpleFSIndexInput.isClone = true;
            return simpleFSIndexInput;
        }

        boolean isFDValid() throws IOException {
            return this.file.getFD().valid();
        }

        @Override
        public void copyBytes(IndexOutput indexOutput, long l) throws IOException {
            l -= (long)this.flushBuffer(indexOutput, l);
            indexOutput.copyBytes(this, l);
        }

        protected static class Descriptor
        extends RandomAccessFile {
            protected volatile boolean isOpen = true;
            long position;
            final long length = this.length();

            public Descriptor(File file, String string) throws IOException {
                super(file, string);
            }

            @Override
            public void close() throws IOException {
                if (this.isOpen) {
                    this.isOpen = false;
                    super.close();
                }
            }
        }
    }
}

