/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;

public class OpenBitSetDISI
extends OpenBitSet {
    public OpenBitSetDISI(DocIdSetIterator docIdSetIterator, int n) throws IOException {
        super(n);
        this.inPlaceOr(docIdSetIterator);
    }

    public OpenBitSetDISI(int n) {
        super(n);
    }

    public void inPlaceOr(DocIdSetIterator docIdSetIterator) throws IOException {
        int n;
        long l = this.size();
        while ((long)(n = docIdSetIterator.nextDoc()) < l) {
            this.fastSet(n);
        }
    }

    public void inPlaceAnd(DocIdSetIterator docIdSetIterator) throws IOException {
        int n;
        int n2 = this.nextSetBit(0);
        while (n2 != -1 && (n = docIdSetIterator.advance(n2)) != Integer.MAX_VALUE) {
            this.clear(n2, n);
            n2 = this.nextSetBit(n + 1);
        }
        if (n2 != -1) {
            this.clear((long)n2, this.size());
        }
    }

    public void inPlaceNot(DocIdSetIterator docIdSetIterator) throws IOException {
        int n;
        long l = this.size();
        while ((long)(n = docIdSetIterator.nextDoc()) < l) {
            this.fastClear(n);
        }
    }

    public void inPlaceXor(DocIdSetIterator docIdSetIterator) throws IOException {
        int n;
        long l = this.size();
        while ((long)(n = docIdSetIterator.nextDoc()) < l) {
            this.fastFlip(n);
        }
    }
}

