/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.search.Scorer;

public class ScorerDocQueue {
    private final HeapedScorerDoc[] heap;
    private final int maxSize;
    private int size = 0;
    private HeapedScorerDoc topHSD;

    public ScorerDocQueue(int n) {
        int n2 = n + 1;
        this.heap = new HeapedScorerDoc[n2];
        this.maxSize = n;
        this.topHSD = this.heap[1];
    }

    public final void put(Scorer scorer) {
        ++this.size;
        this.heap[this.size] = new HeapedScorerDoc(scorer);
        this.upHeap();
    }

    public boolean insert(Scorer scorer) {
        if (this.size < this.maxSize) {
            this.put(scorer);
            return true;
        }
        int n = scorer.docID();
        if (this.size > 0 && n >= this.topHSD.doc) {
            this.heap[1] = new HeapedScorerDoc(scorer, n);
            this.downHeap();
            return true;
        }
        return false;
    }

    public final Scorer top() {
        return this.topHSD.scorer;
    }

    public final int topDoc() {
        return this.topHSD.doc;
    }

    public final float topScore() throws IOException {
        return this.topHSD.scorer.score();
    }

    public final boolean topNextAndAdjustElsePop() throws IOException {
        return this.checkAdjustElsePop(this.topHSD.scorer.nextDoc() != Integer.MAX_VALUE);
    }

    public final boolean topSkipToAndAdjustElsePop(int n) throws IOException {
        return this.checkAdjustElsePop(this.topHSD.scorer.advance(n) != Integer.MAX_VALUE);
    }

    private boolean checkAdjustElsePop(boolean bl) {
        if (bl) {
            this.topHSD.doc = this.topHSD.scorer.docID();
        } else {
            this.heap[1] = this.heap[this.size];
            this.heap[this.size] = null;
            --this.size;
        }
        this.downHeap();
        return bl;
    }

    public final Scorer pop() {
        Scorer scorer = this.topHSD.scorer;
        this.popNoResult();
        return scorer;
    }

    private final void popNoResult() {
        this.heap[1] = this.heap[this.size];
        this.heap[this.size] = null;
        --this.size;
        this.downHeap();
    }

    public final void adjustTop() {
        this.topHSD.adjust();
        this.downHeap();
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        for (int i = 0; i <= this.size; ++i) {
            this.heap[i] = null;
        }
        this.size = 0;
    }

    private final void upHeap() {
        int n = this.size;
        HeapedScorerDoc heapedScorerDoc = this.heap[n];
        for (int i = n >>> 1; i > 0 && heapedScorerDoc.doc < this.heap[i].doc; i >>>= 1) {
            this.heap[n] = this.heap[i];
            n = i;
        }
        this.heap[n] = heapedScorerDoc;
        this.topHSD = this.heap[1];
    }

    private final void downHeap() {
        int n = 1;
        HeapedScorerDoc heapedScorerDoc = this.heap[n];
        int n2 = n << 1;
        int n3 = n2 + 1;
        if (n3 <= this.size && this.heap[n3].doc < this.heap[n2].doc) {
            n2 = n3;
        }
        while (n2 <= this.size && this.heap[n2].doc < heapedScorerDoc.doc) {
            this.heap[n] = this.heap[n2];
            n = n2;
            n3 = (n2 = n << 1) + 1;
            if (n3 > this.size || this.heap[n3].doc >= this.heap[n2].doc) continue;
            n2 = n3;
        }
        this.heap[n] = heapedScorerDoc;
        this.topHSD = this.heap[1];
    }

    private class HeapedScorerDoc {
        Scorer scorer;
        int doc;

        HeapedScorerDoc(Scorer scorer) {
            this(scorer, scorer.docID());
        }

        HeapedScorerDoc(Scorer scorer, int n) {
            this.scorer = scorer;
            this.doc = n;
        }

        void adjust() {
            this.doc = this.scorer.docID();
        }
    }
}

