/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class Direct16
extends PackedInts.ReaderImpl
implements PackedInts.Mutable {
    private short[] values;
    private static final int BITS_PER_VALUE = 16;

    public Direct16(int n) {
        super(n, 16);
        this.values = new short[n];
    }

    public Direct16(DataInput dataInput, int n) throws IOException {
        super(n, 16);
        int n2;
        short[] sArray = new short[n];
        for (n2 = 0; n2 < n; ++n2) {
            sArray[n2] = dataInput.readShort();
        }
        n2 = n % 4;
        if (n2 != 0) {
            int n3 = 4 - n2;
            for (int i = 0; i < n3; ++i) {
                dataInput.readShort();
            }
        }
        this.values = sArray;
    }

    public Direct16(short[] sArray) {
        super(sArray.length, 16);
        this.values = sArray;
    }

    @Override
    public long get(int n) {
        return 0xFFFFL & (long)this.values[n];
    }

    @Override
    public void set(int n, long l) {
        this.values[n] = (short)(l & 0xFFFFL);
    }

    public long ramBytesUsed() {
        return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.length * 2;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, (short)0);
    }

    @Override
    public Object getArray() {
        return this.values;
    }

    @Override
    public boolean hasArray() {
        return true;
    }
}

